/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster;

import org.apache.catalina.Container;
import org.apache.catalina.ContainerEvent;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.jboss.modcluster.ContainerEventHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CatalinaEventHandlerAdapter
implements LifecycleListener,
ContainerListener {
    private volatile boolean init = false;
    private ContainerEventHandler<Server, Engine, Context> eventHandler;

    public CatalinaEventHandlerAdapter(ContainerEventHandler<Server, Engine, Context> eventHandler) {
        this.eventHandler = eventHandler;
    }

    public void containerEvent(ContainerEvent event) {
        Container container = event.getContainer();
        Object child = event.getData();
        String type = event.getType();
        if (type.equals("addChild")) {
            if (container instanceof Host) {
                ((Lifecycle)child).addLifecycleListener((LifecycleListener)this);
                this.eventHandler.addContext((Context)child);
            } else if (container instanceof Engine) {
                container.addContainerListener((ContainerListener)this);
                Host host = (Host)child;
                if (host != null) {
                    host.addContainerListener((ContainerListener)this);
                }
            }
        } else if (type.equals("removeChild")) {
            if (container instanceof Host) {
                ((Lifecycle)child).removeLifecycleListener((LifecycleListener)this);
                this.eventHandler.removeContext((Context)child);
            } else if (container instanceof Engine) {
                Host host = (Host)child;
                if (host != null) {
                    host.removeContainerListener((ContainerListener)this);
                }
                container.removeContainerListener((ContainerListener)this);
            }
        }
    }

    public void lifecycleEvent(LifecycleEvent event) {
        Lifecycle source = event.getLifecycle();
        String type = event.getType();
        if (type.equals("start")) {
            if (source instanceof Context) {
                this.eventHandler.startContext((Context)source);
            }
        } else if (type.equals("after_start")) {
            if (source instanceof Server) {
                Server server = (Server)source;
                this.eventHandler.init(server);
                this.addListeners(server);
                this.eventHandler.startServer(server);
                this.init = true;
            }
        } else if (type.equals("before_stop")) {
            if (source instanceof Context) {
                this.eventHandler.stopContext((Context)source);
            } else if (source instanceof Server) {
                this.init = false;
                Server server = (Server)source;
                this.removeListeners(server);
                this.eventHandler.stopServer(server);
                this.eventHandler.shutdown();
            }
        } else if (type.equals("periodic") && this.init && source instanceof Engine) {
            this.eventHandler.status((Engine)source);
        }
    }

    private void addListeners(Server server) {
        for (Service service : server.findServices()) {
            Container engine = service.getContainer();
            engine.addContainerListener((ContainerListener)this);
            ((Lifecycle)engine).addLifecycleListener((LifecycleListener)this);
            for (Container host : engine.findChildren()) {
                host.addContainerListener((ContainerListener)this);
                for (Container context : host.findChildren()) {
                    ((Lifecycle)context).addLifecycleListener((LifecycleListener)this);
                }
            }
        }
    }

    private void removeListeners(Server server) {
        for (Service service : server.findServices()) {
            Container engine = service.getContainer();
            engine.removeContainerListener((ContainerListener)this);
            ((Lifecycle)engine).removeLifecycleListener((LifecycleListener)this);
            for (Container host : engine.findChildren()) {
                host.removeContainerListener((ContainerListener)this);
                for (Container context : host.findChildren()) {
                    ((Lifecycle)context).removeLifecycleListener((LifecycleListener)this);
                }
            }
        }
    }
}

