/*
 * Decompiled with CFR 0.152.
 */
package com.jboss.jbossnetwork.product.jbpm.handlers;

import com.jboss.jbossnetwork.product.jbpm.handlers.ActionHandlerException;
import com.jboss.jbossnetwork.product.jbpm.handlers.BaseHandler;
import com.jboss.jbossnetwork.product.jbpm.handlers.HandlerUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jbpm.graph.exe.ExecutionContext;
import org.rhq.core.domain.content.PackageDetailsKey;
import org.rhq.core.pluginapi.content.ContentContext;
import org.rhq.core.pluginapi.content.ContentServices;

public class JONServerDownloadActionHandler
extends BaseHandler {
    private String destinationFileLocation;

    public void run(ExecutionContext executionContext) {
        try {
            PackageDetailsKey key = (PackageDetailsKey)executionContext.getVariable("packageDetailsKey");
            ContentContext contentContext = (ContentContext)executionContext.getVariable("contentContext");
            this.downloadBits(key, contentContext);
            this.complete(executionContext, "Successfully downloaded file to [" + HandlerUtils.formatPath(this.destinationFileLocation) + "].");
        }
        catch (Throwable t) {
            this.error(executionContext, t, "Failed to download file to [" + HandlerUtils.formatPath(this.destinationFileLocation) + "].", "error");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadBits(PackageDetailsKey key, ContentContext contentContext) throws IOException, ActionHandlerException {
        ContentServices contentServices = contentContext.getContentServices();
        FileOutputStream output = new FileOutputStream(this.destinationFileLocation);
        BufferedOutputStream bufferedOutput = new BufferedOutputStream(output, 4096);
        try {
            contentServices.downloadPackageBits(contentContext, key, (OutputStream)bufferedOutput, true);
            bufferedOutput.close();
            File downloadedFile = new File(this.destinationFileLocation);
            if (!downloadedFile.exists()) {
                throw new ActionHandlerException("File to download [" + this.destinationFileLocation + "] does not exist");
            }
            if (downloadedFile.length() == 0L) {
                throw new ActionHandlerException("File [" + this.destinationFileLocation + "] is empty");
            }
        }
        finally {
            try {
                bufferedOutput.close();
            }
            catch (IOException e1) {
                this.logger.error((Object)("Error closing output stream to [" + this.destinationFileLocation + "] after exception"), (Throwable)e1);
            }
        }
    }

    public String getDescription() {
        return "Download file from the server and save it to [" + HandlerUtils.formatPath(this.destinationFileLocation) + "].";
    }

    public void setPropertyDefaults() {
        if (this.destinationFileLocation == null) {
            this.destinationFileLocation = "#{downloadFolder}/#{software.filename}";
        }
    }

    protected void checkProperties() throws ActionHandlerException {
        HandlerUtils.checkIsSet("destinationFileLocation", this.destinationFileLocation);
    }

    public void substituteVariables(ExecutionContext executionContext) throws ActionHandlerException {
        this.destinationFileLocation = this.substituteVariable(this.destinationFileLocation, executionContext);
    }

    public String getDestinationFileLocation() {
        return this.destinationFileLocation;
    }

    public void setDestinationFileLocation(String destinationFileLocation) {
        this.destinationFileLocation = destinationFileLocation;
    }
}

