/*
 * Decompiled with CFR 0.152.
 */
package com.jboss.jbossnetwork.product.jbpm.handlers;

import com.jboss.jbossnetwork.product.jbpm.handlers.ActionHandlerException;
import com.jboss.jbossnetwork.product.jbpm.handlers.ActionHandlerMessageLog;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.jpdl.el.impl.JbpmExpressionEvaluator;
import org.jbpm.logging.log.ProcessLog;
import org.rhq.core.clientapi.util.StringUtil;
import org.rhq.core.domain.content.transfer.ContentResponseResult;
import org.rhq.core.domain.content.transfer.DeployPackageStep;

public abstract class BaseHandler
implements ActionHandler {
    protected static final String TRANSITION_SUCCESS = "success";
    protected static final String TRANSITION_ERROR = "error";
    protected static final String MESSAGE_NO_CHANGES = "No changes were made in this step.";
    protected final Log logger = LogFactory.getLog(this.getClass());

    public abstract String getDescription();

    public abstract void run(ExecutionContext var1);

    public void setPropertyDefaults() {
    }

    public void substituteVariables(ExecutionContext executionContext) throws ActionHandlerException {
    }

    protected void checkProperties() throws ActionHandlerException {
    }

    public void execute(ExecutionContext executionContext) throws Exception {
        try {
            String nodeName;
            if (this.logger.isDebugEnabled()) {
                nodeName = executionContext.getNode().getName();
                this.logger.debug((Object)("Description of step [" + nodeName + "] prior to setting defaults: " + this.getDescription()));
            }
            this.setPropertyDefaults();
            if (this.logger.isDebugEnabled()) {
                nodeName = executionContext.getNode().getName();
                this.logger.debug((Object)("Description of step [" + nodeName + "] prior to substituting variables: " + this.getDescription()));
            }
            this.substituteVariables(executionContext);
            if (this.logger.isDebugEnabled()) {
                nodeName = executionContext.getNode().getName();
                this.logger.debug((Object)("Description of step [" + nodeName + "] prior to checking properties: " + this.getDescription()));
            }
            this.checkProperties();
        }
        catch (ActionHandlerException e) {
            this.error(executionContext, e, MESSAGE_NO_CHANGES, TRANSITION_ERROR);
            return;
        }
        try {
            this.run(executionContext);
        }
        catch (Exception e) {
            this.logger.error((Object)"Error caught from run", (Throwable)e);
        }
    }

    protected void error(ExecutionContext executionContext, Throwable throwable, String additionalMessage, String leavingTransition) {
        String nodeName = executionContext.getNode().getName();
        ActionHandlerMessageLog log = this.logStep(executionContext, throwable, additionalMessage, ContentResponseResult.FAILURE);
        this.logger.info((Object)("Description of step [" + nodeName + "]: " + this.getDescription()));
        this.logger.error((Object)("Result of step [" + nodeName + "]: " + (Object)((Object)log)));
        executionContext.leaveNode(leavingTransition);
    }

    protected void complete(ExecutionContext executionContext, String message) {
        String nodeName = executionContext.getNode().getName();
        this.logger.info((Object)("Description of step [" + nodeName + "]: " + this.getDescription()));
        ActionHandlerMessageLog log = this.logStep(executionContext, null, message, ContentResponseResult.SUCCESS);
        this.logger.info((Object)("Result of step [" + nodeName + "]: " + (Object)((Object)log)));
        executionContext.leaveNode(TRANSITION_SUCCESS);
    }

    protected void skip(ExecutionContext executionContext, ActionHandlerException exception, String additionalMessage, String leavingTransition) {
        String nodeName = executionContext.getNode().getName();
        ActionHandlerMessageLog log = this.logStep(executionContext, exception, additionalMessage, ContentResponseResult.NOT_PERFORMED);
        this.logger.info((Object)("Description of step [" + nodeName + "]: " + this.getDescription()));
        this.logger.warn((Object)("Result of step [" + nodeName + "]: " + (Object)((Object)log)));
        executionContext.leaveNode(leavingTransition);
    }

    protected void notRun(ExecutionContext executionContext, String message) {
        String nodeName = executionContext.getNode().getName();
        ActionHandlerMessageLog log = this.logStep(executionContext, null, message, ContentResponseResult.NOT_PERFORMED);
        this.logger.info((Object)("Result of step [" + nodeName + "]: " + (Object)((Object)log)));
        executionContext.leaveNode(TRANSITION_SUCCESS);
    }

    private ActionHandlerMessageLog logStep(ExecutionContext executionContext, Throwable throwable, String additionalMessage, ContentResponseResult result) {
        ActionHandlerMessageLog log = new ActionHandlerMessageLog();
        Integer stepCounter = (Integer)executionContext.getVariable("stepCounter");
        if (stepCounter == null) {
            stepCounter = 0;
        }
        Integer n = stepCounter;
        Integer n2 = stepCounter = Integer.valueOf(stepCounter + 1);
        executionContext.setVariable("stepCounter", (Object)stepCounter);
        String description = throwable == null ? additionalMessage : throwable.getMessage();
        DeployPackageStep step = new DeployPackageStep(Integer.toString(stepCounter), description);
        step.setStepResult(result);
        if (throwable != null) {
            String errorMessage = StringUtil.getStackTrace((Throwable)throwable);
            step.setStepErrorMessage(errorMessage);
        }
        log.setStep(step);
        executionContext.getProcessInstance().getLoggingInstance().addLog((ProcessLog)log);
        return log;
    }

    protected String substituteVariable(String expression, ExecutionContext executionContext) throws ActionHandlerException {
        if (expression == null) {
            return null;
        }
        Object valueAfterSubst = JbpmExpressionEvaluator.evaluate((String)expression, (ExecutionContext)executionContext);
        return (String)valueAfterSubst;
    }
}

