/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.attribute.EmsAttribute;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.CreateChildResourceFacet;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.plugins.jbossas.JBossASServerComponent;
import org.rhq.plugins.jbossas.JBossMessagingComponent;
import org.rhq.plugins.jbossas.JMSComponent;
import org.rhq.plugins.jbossas.util.DeploymentUtility;
import org.rhq.plugins.jbossas.util.XMLConfigurationEditor;
import org.rhq.plugins.jmx.MBeanResourceComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMessagingComponent
extends MBeanResourceComponent<JBossASServerComponent>
implements CreateChildResourceFacet {
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("^(.*:.*):(.*)$");
    protected static final String PLUGIN_CONFIG_NAME_PROP = "name";
    private static final String MBEAN_NAME_PROP = "MBeanName";
    XMLConfigurationEditor xmlEditor;
    ResourceType resourceType;
    protected String name;
    protected Log LOG = null;

    public void start(ResourceContext<JBossASServerComponent> resourceContext, XMLConfigurationEditor editor) {
        super.start(resourceContext);
        this.resourceType = resourceContext.getResourceType();
        this.xmlEditor = editor;
        this.name = resourceContext.getPluginConfiguration().getSimpleValue(PLUGIN_CONFIG_NAME_PROP, null);
    }

    protected void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests, String pattern) {
        HashSet<MeasurementScheduleRequest> others = new HashSet<MeasurementScheduleRequest>();
        for (MeasurementScheduleRequest request : requests) {
            if (request.getName().startsWith(pattern)) {
                Matcher m = PROPERTY_PATTERN.matcher(request.getName());
                if (!m.matches() || m.group(1) == null) continue;
                EmsBean eBean = this.getEmsConnection().getBean(m.group(1));
                ArrayList<String> attributes = new ArrayList<String>(1);
                attributes.add(m.group(2));
                eBean.refreshAttributes(attributes);
                EmsAttribute emsAtt = eBean.getAttribute(m.group(2));
                Object value = emsAtt.getValue();
                if (request.getDataType() == DataType.MEASUREMENT && value instanceof Number) {
                    report.addData(new MeasurementDataNumeric(request, Double.valueOf(((Number)value).doubleValue())));
                    continue;
                }
                if (request.getDataType() != DataType.TRAIT) continue;
                String displayValue = null;
                displayValue = value != null && value.getClass().isArray() ? Arrays.deepToString((Object[])value) : String.valueOf(value);
                report.addData(new MeasurementDataTrait(request, displayValue));
                continue;
            }
            others.add(request);
        }
        super.getValues(report, others);
    }

    public Configuration loadResourceConfiguration() {
        String resourceKey = this.resourceContext.getResourceKey();
        JBossASServerComponent jasco = this.getOurJBossASComponent();
        File deploymentFile = jasco.getDeploymentFilePath(resourceKey);
        Configuration loadedConfiguration = this.xmlEditor.loadConfiguration(deploymentFile, this.name);
        String boundJNDIName = DeploymentUtility.getJndiNameBinding(this.getEmsBean());
        loadedConfiguration.put((Property)new PropertySimple("JNDIBinding", (Object)boundJNDIName));
        return loadedConfiguration;
    }

    private JBossASServerComponent getOurJBossASComponent() {
        ResourceComponent parent = this.resourceContext.getParentResourceComponent();
        JBossASServerComponent jasco = parent instanceof JMSComponent ? (JBossASServerComponent)((JMSComponent)parent).resourceContext.getParentResourceComponent() : (parent instanceof JBossMessagingComponent ? (JBossASServerComponent)((JBossMessagingComponent)parent).resourceContext.getParentResourceComponent() : (parent instanceof JBossASServerComponent ? (JBossASServerComponent)parent : new JBossASServerComponent()));
        return jasco;
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        JBossASServerComponent jasco = this.getOurJBossASComponent();
        File deploymentFile = jasco.getDeploymentFilePath(this.resourceContext.getResourceKey());
        String mBeanName = report.getConfiguration().getSimpleValue(MBEAN_NAME_PROP, null);
        boolean mBeanNameChanged = false;
        if (!mBeanName.equals(this.name)) {
            this.LOG.info((Object)"The MBEan Name for this Topic/Queue has been changed. This change will appear in the <mbean> tag forthis Topic/Queue.");
            PropertySimple nameProp = this.resourceContext.getPluginConfiguration().getSimple(PLUGIN_CONFIG_NAME_PROP);
            nameProp.setStringValue(mBeanName);
            mBeanNameChanged = true;
        }
        if (deploymentFile == null || !deploymentFile.exists()) {
            deploymentFile = new File(((JBossASServerComponent)this.resourceContext.getParentResourceComponent()).getConfigurationPath(), this.name + ".xml");
        }
        this.xmlEditor.updateConfiguration(deploymentFile, this.name, report);
        if (mBeanNameChanged) {
            this.name = mBeanName;
        }
    }

    public void deleteResource() throws Exception {
        String resourceKey = this.resourceContext.getResourceKey();
        JBossASServerComponent parent = this.getOurJBossASComponent();
        File deploymentFile = parent.getDeploymentFilePath(resourceKey);
        assert (deploymentFile.exists()) : "Deployment file " + deploymentFile + " doesn't exist for resource " + resourceKey;
        this.xmlEditor.deleteComponent(deploymentFile, this.name);
        parent.redeployFile(deploymentFile);
    }

    public String getCanonicalName(String objectName) throws MalformedObjectNameException {
        ObjectName on = new ObjectName(objectName);
        return on.getCanonicalName();
    }
}

