/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas;

import java.io.File;
import java.util.Set;
import org.mc4j.ems.connection.bean.EmsBean;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.DeleteResourceFacet;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.plugins.jbossas.JBossASServerComponent;
import org.rhq.plugins.jbossas.util.DatasourceConfigurationEditor;
import org.rhq.plugins.jbossas.util.JBossMBeanUtility;
import org.rhq.plugins.jmx.MBeanResourceComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatasourceComponent
extends MBeanResourceComponent<JBossASServerComponent>
implements ConfigurationFacet,
DeleteResourceFacet,
OperationFacet {
    private static final String CONNECTION_POOL_OBJECT_NAME = "jboss.jca:name=%NAME%,service=ManagedConnectionPool";
    private String name;
    private String connectionPoolBeanName;
    private EmsBean connectionPoolBean;

    public AvailabilityType getAvailability() {
        return JBossMBeanUtility.isStarted(this.getEmsBean(), this.resourceContext) ? AvailabilityType.UP : AvailabilityType.DOWN;
    }

    public void start(ResourceContext<JBossASServerComponent> resourceContext) {
        super.start(resourceContext);
        this.name = this.resourceContext.getPluginConfiguration().getSimpleValue("name", null);
        this.connectionPoolBeanName = CONNECTION_POOL_OBJECT_NAME.replace("%NAME%", this.name);
        this.connectionPoolBean = this.getConnectionPoolBean();
    }

    public Configuration loadResourceConfiguration() {
        File deploymentFile = ((JBossASServerComponent)this.resourceContext.getParentResourceComponent()).getDeploymentFilePath(this.resourceContext.getResourceKey());
        assert (deploymentFile.exists()) : "Deployment file " + deploymentFile + " doesn't exist for Datasource [" + this.resourceContext.getResourceKey() + "].";
        return DatasourceConfigurationEditor.loadDatasource(deploymentFile, this.name);
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        JBossASServerComponent parentComponent = (JBossASServerComponent)this.resourceContext.getParentResourceComponent();
        File deploymentFile = parentComponent.getDeploymentFilePath(this.resourceContext.getResourceKey());
        if (deploymentFile == null) {
            report.setErrorMessage("Parent Resource is currently down - unable to complete update of Datasource [" + this.name + "].");
            report.setStatus(ConfigurationUpdateStatus.FAILURE);
        } else {
            if (!deploymentFile.exists()) {
                deploymentFile = new File(parentComponent.getConfigurationPath(), this.name + "-ds.xml");
            }
            DatasourceConfigurationEditor.updateDatasource(deploymentFile, this.name, report);
        }
    }

    public void deleteResource() throws Exception {
        JBossASServerComponent jbossASComponent = (JBossASServerComponent)this.resourceContext.getParentResourceComponent();
        File deploymentFile = jbossASComponent.getDeploymentFilePath(this.resourceContext.getResourceKey());
        assert (deploymentFile.exists()) : "Deployment file " + deploymentFile + " doesn't exist for Datasource [" + this.resourceContext.getResourceKey() + "].";
        DatasourceConfigurationEditor.deleteDataSource(deploymentFile, this.name);
        jbossASComponent.redeployFile(deploymentFile);
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests) {
        super.getValues(report, requests, this.getConnectionPoolBean());
    }

    public OperationResult invokeOperation(String name, Configuration parameters) throws Exception {
        return super.invokeOperation(name, parameters, this.getConnectionPoolBean());
    }

    private EmsBean getConnectionPoolBean() {
        if (this.connectionPoolBean == null) {
            this.connectionPoolBean = this.loadBean(this.connectionPoolBeanName);
        }
        return this.connectionPoolBean;
    }
}

