/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas;

import java.io.File;
import java.util.Set;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.applications.ApplicationResourceComponent;
import org.rhq.plugins.jbossas.JBossASServerComponent;
import org.rhq.plugins.jbossas.util.WarDiscoveryHelper;
import org.rhq.plugins.jmx.JMXComponent;
import org.rhq.plugins.jmx.MBeanResourceDiscoveryComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbeddedWarDiscoveryComponent
extends MBeanResourceDiscoveryComponent {
    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<JMXComponent> context) {
        ApplicationResourceComponent parentEarComponent = (ApplicationResourceComponent)context.getParentResourceComponent();
        String parentEar = parentEarComponent.getApplicationName();
        String objectName = "jboss.management.local:J2EEApplication=" + parentEar + ",J2EEServer=Local,j2eeType=WebModule,name=%name%";
        Configuration defaultPluginConfiguration = context.getDefaultPluginConfiguration();
        defaultPluginConfiguration.put((Property)new PropertySimple("objectName", (Object)objectName));
        Set<DiscoveredResourceDetails> resourceDetails = super.performDiscovery(defaultPluginConfiguration, (JMXComponent)parentEarComponent, context.getResourceType());
        JBossASServerComponent grandparentJBossASComponent = (JBossASServerComponent)parentEarComponent.getParentResourceComponent();
        resourceDetails = WarDiscoveryHelper.initPluginConfigurations(grandparentJBossASComponent, resourceDetails);
        String parentEarFullFileName = parentEarComponent.getFileName() + File.separator;
        for (DiscoveredResourceDetails resource : resourceDetails) {
            Configuration pluginConfiguration = resource.getPluginConfiguration();
            pluginConfiguration.put((Property)new PropertySimple("filename", (Object)(parentEarFullFileName + resource.getResourceName())));
        }
        return resourceDetails;
    }
}

