/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.attribute.EmsAttribute;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.plugins.jbossas.JBossASTomcatServerComponent;
import org.rhq.plugins.jmx.MBeanResourceComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossASTomcatConnectorComponent
extends MBeanResourceComponent<JBossASTomcatServerComponent> {
    public static final String PROPERTY_ADDRESS = "address";
    public static final String PROPERTY_PORT = "port";
    public static final String PROPERTY_SCHEMA = "schema";
    public static final String PROPERTY_DASH = "-";
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests) {
        JBossASTomcatServerComponent parentTomcatComponent = (JBossASTomcatServerComponent)this.resourceContext.getParentResourceComponent();
        parentTomcatComponent.getEmsConnection();
        for (MeasurementScheduleRequest request : requests) {
            String name = request.getName();
            name = this.getAttributeName(name);
            String beanName = name.substring(0, name.lastIndexOf(58));
            String attributeName = name.substring(name.lastIndexOf(58) + 1);
            try {
                EmsBean eBean = this.loadBean(beanName);
                if (eBean == null) {
                    this.log.warn((Object)("Bean " + beanName + " not found, skipping ..."));
                    continue;
                }
                EmsAttribute attribute = eBean.getAttribute(attributeName);
                Object valueObject = attribute.refresh();
                Number value = (Number)valueObject;
                report.addData(new MeasurementDataNumeric(request, Double.valueOf(value.doubleValue())));
            }
            catch (Exception e) {
                this.log.error((Object)("Failed to obtain measurement [" + name + "]"), (Throwable)e);
            }
        }
    }

    protected String getAttributeName(String property) {
        String theProperty = property;
        Configuration pluginConfiguration = this.resourceContext.getPluginConfiguration();
        String address = pluginConfiguration.getSimple(PROPERTY_ADDRESS).getStringValue();
        String port = pluginConfiguration.getSimple(PROPERTY_PORT).getStringValue();
        String schema = pluginConfiguration.getSimple(PROPERTY_SCHEMA).getStringValue();
        String dash = pluginConfiguration.getSimple(PROPERTY_DASH).getStringValue();
        theProperty = theProperty.replace("%address%", address);
        theProperty = theProperty.replace("%port%", port);
        theProperty = theProperty.replace("%schema%", schema);
        theProperty = theProperty.replace("%dash%", dash);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Finding metrics for: " + theProperty));
        }
        return theProperty;
    }
}

