/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.Nullable;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.attribute.EmsAttribute;
import org.mc4j.ems.connection.bean.operation.EmsOperation;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.measurement.calltime.CallTimeData;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.core.pluginapi.util.ResponseTimeConfiguration;
import org.rhq.core.pluginapi.util.ResponseTimeLogParser;
import org.rhq.plugins.applications.ApplicationResourceComponent;
import org.rhq.plugins.jbossas.JBossASServerComponent;
import org.rhq.plugins.jbossas.util.DeploymentUtility;
import org.rhq.plugins.jbossas.util.WarDeploymentInformation;
import org.rhq.plugins.jbossas.util.WarDiscoveryHelper;
import org.rhq.plugins.jmx.ObjectNameQueryUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WarComponent
extends ApplicationResourceComponent<JBossASServerComponent>
implements OperationFacet {
    private static final String SERVLET_PREFIX = "Servlet.";
    public static final String CONTEXT_ROOT_CONFIG_PROP = "contextRoot";
    public static final String NAME_CONFIG_PROP = "name";
    public static final String FILE_NAME = "filename";
    public static final String JBOSS_WEB_NAME = "jbossWebName";
    public static final String RESPONSE_TIME_LOG_FILE_CONFIG_PROP = "responseTimeLogFile";
    public static final String RESPONSE_TIME_URL_EXCLUDES_CONFIG_PROP = "responseTimeUrlExcludes";
    public static final String RESPONSE_TIME_URL_TRANSFORMS_CONFIG_PROP = "responseTimeUrlTransforms";
    private static final String RESPONSE_TIME_METRIC = "ResponseTime";
    private static final String CONTEXT_ROOT_METRIC = "ContextRoot";
    private static final String MAX_SERVLET_TIME = "Servlet.MaxResponseTime";
    private static final String MIN_SERVLET_TIME = "Servlet.MinResponseTime";
    private static final String AVG_SERVLET_TIME = "Servlet.AvgResponseTime";
    private static final String NUM_SERVLET_REQUESTS = "Servlet.NumRequests";
    private static final String NUM_SERVLET_ERRORS = "Servlet.NumErrors";
    private static final String TOTAL_TIME = "Servlet.TotalTime";
    private static final String SERVLET_NAME_BASE_TEMPLATE = "jboss.web:J2EEApplication=none,J2EEServer=none,j2eeType=Servlet,name=%name%";
    private static final String SESSION_NAME_BASE_TEMPLATE = "jboss.web:host=%HOST%,type=Manager,path=%PATH%";
    private static final String SESSION_PREFIX = "Session.";
    private static final String VHOST_PREFIX = "Vhost";
    public static final String VHOST_CONFIG_PROP = "vHost";
    public static final String ROOT_WEBAPP_CONTEXT_ROOT = "/";
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private EmsBean jbossWebMBean;
    private ResponseTimeLogParser logParser;
    String vhost;
    private String contextRoot;

    public AvailabilityType getAvailability() {
        AvailabilityType availability;
        if (this.jbossWebMBean != null) {
            int state = (Integer)this.jbossWebMBean.getAttribute("state").refresh();
            availability = state == 1 ? AvailabilityType.UP : AvailabilityType.DOWN;
        } else {
            this.jbossWebMBean = this.getJBossWebMBean();
            availability = this.jbossWebMBean == null ? AvailabilityType.DOWN : this.getAvailability();
        }
        return availability;
    }

    public void start(ResourceContext resourceContext) {
        super.start(resourceContext);
        Configuration pluginConfig = this.resourceContext.getPluginConfiguration();
        this.jbossWebMBean = this.getJBossWebMBean();
        this.vhost = pluginConfig.getSimple(VHOST_CONFIG_PROP).getStringValue();
        this.contextRoot = pluginConfig.getSimple(CONTEXT_ROOT_CONFIG_PROP).getStringValue();
        ResponseTimeConfiguration responseTimeConfig = new ResponseTimeConfiguration(pluginConfig);
        File logFile = responseTimeConfig.getLogFile();
        if (logFile != null) {
            this.logParser = new ResponseTimeLogParser(logFile);
            this.logParser.setExcludes(responseTimeConfig.getExcludes());
            this.logParser.setTransforms(responseTimeConfig.getTransforms());
        }
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> schedules) {
        LinkedHashSet<MeasurementScheduleRequest> remainingSchedules = new LinkedHashSet<MeasurementScheduleRequest>();
        for (MeasurementScheduleRequest schedule : schedules) {
            MeasurementDataNumeric metric;
            Double value;
            String metricName = schedule.getName();
            if (metricName.equals(RESPONSE_TIME_METRIC)) {
                if (this.logParser != null) {
                    try {
                        CallTimeData callTimeData = new CallTimeData(schedule);
                        this.logParser.parseLog(callTimeData);
                        report.addData(callTimeData);
                    }
                    catch (Exception e) {
                        this.log.error((Object)"Failed to retrieve HTTP call-time data.", (Throwable)e);
                    }
                    continue;
                }
                this.log.error((Object)("The 'ResponseTime' metric is enabled for WAR resource '" + this.getApplicationName() + "', but no value is defined for the '" + RESPONSE_TIME_LOG_FILE_CONFIG_PROP + "' connection property."));
                continue;
            }
            if (metricName.equals(CONTEXT_ROOT_METRIC)) {
                MeasurementDataTrait trait = new MeasurementDataTrait(schedule, this.contextRoot);
                report.addData(trait);
                continue;
            }
            if (metricName.startsWith(SERVLET_PREFIX)) {
                value = this.getServletMetric(metricName);
                metric = new MeasurementDataNumeric(schedule, value);
                report.addData(metric);
                continue;
            }
            if (metricName.startsWith(SESSION_PREFIX)) {
                value = this.getSessionMetric(metricName);
                metric = new MeasurementDataNumeric(schedule, value);
                report.addData(metric);
                continue;
            }
            if (metricName.startsWith(VHOST_PREFIX)) {
                if (!metricName.equals("Vhost.name")) continue;
                List<EmsBean> beans = this.getVHosts(this.contextRoot);
                String value2 = "";
                Iterator<EmsBean> iter = beans.iterator();
                while (iter.hasNext()) {
                    EmsBean eBean = iter.next();
                    value2 = value2 + eBean.getBeanName().getKeyProperty("host");
                    if (!iter.hasNext()) continue;
                    value2 = value2 + ",";
                }
                MeasurementDataTrait trait = new MeasurementDataTrait(schedule, value2);
                report.addData(trait);
                continue;
            }
            remainingSchedules.add(schedule);
        }
    }

    private Double getSessionMetric(String metricName) {
        EmsConnection jmxConnection = this.getEmsConnection();
        String ctxRoot = ROOT_WEBAPP_CONTEXT_ROOT + this.contextRoot;
        String servletMBeanNames = SESSION_NAME_BASE_TEMPLATE.replace("%PATH%", ctxRoot);
        servletMBeanNames = servletMBeanNames.replace("%HOST%", this.vhost);
        ObjectNameQueryUtility queryUtility = new ObjectNameQueryUtility(servletMBeanNames);
        List mBeans = jmxConnection.queryBeans(queryUtility.getTranslatedQuery());
        String property = metricName.substring(SESSION_PREFIX.length());
        Double ret = Double.NaN;
        if (mBeans.size() > 0) {
            EmsBean eBean = (EmsBean)mBeans.get(0);
            eBean.refreshAttributes();
            EmsAttribute att = eBean.getAttribute(property);
            if (att != null) {
                Integer i = (Integer)att.getValue();
                ret = new Double(i.intValue());
            }
        }
        return ret;
    }

    private Double getServletMetric(String metricName) {
        EmsConnection jmxConnection = this.getEmsConnection();
        String servletMBeanNames = "jboss.web:J2EEApplication=none,J2EEServer=none,j2eeType=Servlet,name=%name%,WebModule=//" + this.vhost + WarDiscoveryHelper.getContextPath(this.contextRoot);
        ObjectNameQueryUtility queryUtility = new ObjectNameQueryUtility(servletMBeanNames);
        List mBeans = jmxConnection.queryBeans(queryUtility.getTranslatedQuery());
        long min = Long.MAX_VALUE;
        long max = 0L;
        long processingTime = 0L;
        int requestCount = 0;
        int errorCount = 0;
        for (EmsBean mBean : mBeans) {
            Integer i;
            Long l;
            EmsAttribute att;
            mBean.refreshAttributes();
            if (metricName.equals(MIN_SERVLET_TIME)) {
                att = mBean.getAttribute("minTime");
                l = (Long)att.getValue();
                if (l >= min) continue;
                min = l;
                continue;
            }
            if (metricName.equals(MAX_SERVLET_TIME)) {
                att = mBean.getAttribute("maxTime");
                l = (Long)att.getValue();
                if (l <= max) continue;
                max = l;
                continue;
            }
            if (metricName.equals(AVG_SERVLET_TIME)) {
                att = mBean.getAttribute("processingTime");
                l = (Long)att.getValue();
                processingTime += l.longValue();
                att = mBean.getAttribute("requestCount");
                Integer i2 = (Integer)att.getValue();
                requestCount += i2.intValue();
                continue;
            }
            if (metricName.equals(NUM_SERVLET_REQUESTS)) {
                att = mBean.getAttribute("requestCount");
                i = (Integer)att.getValue();
                requestCount += i.intValue();
                continue;
            }
            if (metricName.equals(NUM_SERVLET_ERRORS)) {
                att = mBean.getAttribute("errorCount");
                i = (Integer)att.getValue();
                errorCount += i.intValue();
                continue;
            }
            if (!metricName.equals(TOTAL_TIME)) continue;
            att = mBean.getAttribute("processingTime");
            l = (Long)att.getValue();
            processingTime += l.longValue();
        }
        Double result = metricName.equals(AVG_SERVLET_TIME) ? Double.valueOf(requestCount > 0 ? (double)processingTime / (double)requestCount : Double.NaN) : (metricName.equals(MIN_SERVLET_TIME) ? Double.valueOf(min != Long.MAX_VALUE ? (double)min : Double.NaN) : (metricName.equals(MAX_SERVLET_TIME) ? Double.valueOf(max != 0L ? (double)max : Double.NaN) : (metricName.equals(NUM_SERVLET_ERRORS) ? Double.valueOf(errorCount) : (metricName.equals(NUM_SERVLET_REQUESTS) ? Double.valueOf(requestCount) : (metricName.equals(TOTAL_TIME) ? Double.valueOf(processingTime) : Double.valueOf(Double.NaN))))));
        return result;
    }

    public OperationResult invokeOperation(String name, Configuration params) throws Exception {
        WarOperation operation = this.getOperation(name);
        if (this.jbossWebMBean == null) {
            throw new IllegalStateException("Could not find jboss.web MBean for WAR '" + this.getApplicationName() + "'.");
        }
        EmsOperation mbeanOperation = this.jbossWebMBean.getOperation(name);
        if (mbeanOperation == null) {
            throw new IllegalStateException("Operation [" + name + "] not found on bean [" + this.jbossWebMBean.getBeanName() + "]");
        }
        Object[] paramValues = new Object[]{};
        mbeanOperation.invoke(paramValues);
        int state = (Integer)this.jbossWebMBean.getAttribute("state").refresh();
        int expectedState = WarComponent.getExpectedPostExecutionState(operation);
        if (state != expectedState) {
            throw new Exception("Failed to " + name + " webapp (value of the 'state' attribute of MBean '" + this.jbossWebMBean.getBeanName() + "' is " + state + ", not " + expectedState + ").");
        }
        return new OperationResult();
    }

    private static int getExpectedPostExecutionState(WarOperation operation) {
        int expectedState;
        switch (operation) {
            case START: 
            case RELOAD: {
                expectedState = 1;
                break;
            }
            case STOP: {
                expectedState = 0;
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported operation: " + (Object)((Object)operation));
            }
        }
        return expectedState;
    }

    private WarOperation getOperation(String name) {
        try {
            return WarOperation.valueOf(name.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid operation name: " + name);
        }
    }

    @Nullable
    private EmsBean getJBossWebMBean() {
        String jbossWebMBeanName = this.getJBossWebMBeanName();
        if (jbossWebMBeanName != null) {
            ObjectNameQueryUtility queryUtility = new ObjectNameQueryUtility(jbossWebMBeanName);
            List mBeans = this.getEmsConnection().queryBeans(queryUtility.getTranslatedQuery());
            if (mBeans.size() == 1) {
                return (EmsBean)mBeans.get(0);
            }
        }
        return null;
    }

    @Nullable
    private String getJBossWebMBeanName() {
        WarDeploymentInformation deploymentInformation;
        Configuration pluginConfig = this.resourceContext.getPluginConfiguration();
        String jbossWebMBeanName = pluginConfig.getSimpleValue(JBOSS_WEB_NAME, null);
        if (jbossWebMBeanName == null && (deploymentInformation = this.getDeploymentInformation()) != null) {
            jbossWebMBeanName = deploymentInformation.getJbossWebModuleMBeanObjectName();
            WarDiscoveryHelper.setDeploymentInformation(pluginConfig, deploymentInformation);
        }
        return jbossWebMBeanName;
    }

    private List<EmsBean> getVHosts(String contextRoot) {
        return DeploymentUtility.getVHosts(contextRoot, this.getEmsConnection());
    }

    private WarDeploymentInformation getDeploymentInformation() {
        WarDeploymentInformation deploymentInformation = null;
        EmsBean mBean = this.getEmsBean();
        if (mBean != null && mBean.getBeanName() != null) {
            String beanName = this.getEmsBean().getBeanName().getCanonicalName();
            ArrayList<String> beanNameList = new ArrayList<String>();
            beanNameList.add(beanName);
        }
        return deploymentInformation;
    }

    private static interface JBossWebMBeanState {
        public static final int STOPPED = 0;
        public static final int STARTED = 1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum WarOperation {
        START,
        STOP,
        RELOAD;

    }
}

