/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas.helper;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.operation.EmsOperation;
import org.rhq.plugins.jbossas.util.EmsUtility;

public class MainDeployer {
    private final Log log = LogFactory.getLog(this.getClass());
    private EmsOperation deployOperation;
    private EmsOperation redeployOperation;

    public MainDeployer(EmsConnection connection) throws NoSuchMethodException {
        EmsBean mainDeployer = connection.getBean("jboss.system:service=MainDeployer");
        if (mainDeployer == null) {
            throw new IllegalStateException("MBean named [jboss.system:service=MainDeployer] does not exist.");
        }
        this.deployOperation = EmsUtility.getOperation(mainDeployer, "deploy", URL.class);
        this.redeployOperation = EmsUtility.getOperation(mainDeployer, "redeploy", URL.class);
    }

    public void deploy(File file) throws Exception {
        this.log.debug((Object)("Deploying " + file + "..."));
        try {
            URL url = MainDeployer.toURL(file);
            this.deployOperation.invoke(new Object[]{url});
        }
        catch (RuntimeException e) {
            throw new Exception("Failed to deploy " + file, e);
        }
    }

    public void redeploy(File file) throws Exception {
        this.log.debug((Object)("Redeploying " + file + "..."));
        try {
            URL url = MainDeployer.toURL(file);
            this.redeployOperation.invoke(new Object[]{url});
        }
        catch (RuntimeException e) {
            throw new Exception("Failed to redeploy " + file, e);
        }
    }

    private static URL toURL(File file) {
        URL url;
        try {
            url = file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
        return url;
    }
}

