/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;

public class DatasourceConfigurationEditor {
    public static final String NO_TX_TYPE = "no-tx-datasource";
    public static final String LOCAL_TX_TYPE = "local-tx-datasource";
    public static final String XA_TX_TYPE = "xa-tx-datasource";
    public static final String[] COMMON_PROPS = new String[]{"jndi-name", "connection-url", "user-name", "password", "min-pool-size", "max-pool-size", "transaction-isolation", "blocking-timeout-millis", "idle-timeout-minutes", "prepared-statement-cache-size", "valid-connection-checker-class-name", "use-java-context", "security-domain", "new-connection-sql", "exception-sorter-class-name", "check-valid-connection-sql", "track-statements", "no-tx-separate-pools", "application-managed-security", "security-domain-and-application"};
    public static final String[] NON_XA_PROPS = new String[]{"driver-class"};
    public static final String[] XA_PROPS = new String[]{"xa-datasource-class", "track-connection-by-tx", "isSameRM-override-value"};
    private static Log log = LogFactory.getLog(DatasourceConfigurationEditor.class);

    public static Configuration loadDatasource(File file, String name) {
        try {
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(file);
            Element root = doc.getRootElement();
            if (!root.getName().equals("datasources")) {
                return null;
            }
            Element datasourceElement = DatasourceConfigurationEditor.findDatasourceElement(root, name);
            if (datasourceElement == null) {
                return null;
            }
            Configuration config = new Configuration();
            String type = datasourceElement.getName();
            config.put((Property)new PropertySimple("type", (Object)type));
            DatasourceConfigurationEditor.bindElements(datasourceElement, config, COMMON_PROPS);
            if (type.equals(XA_TX_TYPE)) {
                DatasourceConfigurationEditor.bindElements(datasourceElement, config, XA_PROPS);
                DatasourceConfigurationEditor.bindMap(datasourceElement, config, "xa-datasource-properties");
            } else {
                DatasourceConfigurationEditor.bindElements(datasourceElement, config, NON_XA_PROPS);
                DatasourceConfigurationEditor.bindMap(datasourceElement, config, "connection-property");
            }
            return config;
        }
        catch (IOException e) {
            log.error((Object)("IO error occurred while reading file: " + file), (Throwable)e);
        }
        catch (JDOMException e) {
            log.error((Object)("Parsing error occurred while reading file: " + file), (Throwable)e);
        }
        return null;
    }

    public static void updateDatasource(File deploymentFile, String name, ConfigurationUpdateReport report) {
        try {
            DatasourceConfigurationEditor.updateDatasource(deploymentFile, name, report.getConfiguration());
            report.setStatus(ConfigurationUpdateStatus.SUCCESS);
        }
        catch (IOException e) {
            report.setErrorMessageFromThrowable((Throwable)e);
            log.error((Object)("IO error occurred while updating datasource at file: " + deploymentFile), (Throwable)e);
        }
        catch (JDOMException e) {
            report.setErrorMessageFromThrowable((Throwable)e);
            log.error((Object)("Parsing error occurred while updating datasource at file: " + deploymentFile), (Throwable)e);
        }
    }

    public static void updateDatasource(File deploymentFile, String name, CreateResourceReport report) {
        try {
            DatasourceConfigurationEditor.updateDatasource(deploymentFile, name, report.getResourceConfiguration());
            report.setStatus(CreateResourceStatus.SUCCESS);
        }
        catch (IOException e) {
            report.setException((Throwable)e);
            log.error((Object)("IO error occurred while updating datasource at file: " + deploymentFile), (Throwable)e);
        }
        catch (JDOMException e) {
            report.setException((Throwable)e);
            log.error((Object)("Parsing error occurred while updating datasource at file: " + deploymentFile), (Throwable)e);
        }
    }

    private static void updateDatasource(File deploymentFile, String name, Configuration config) throws JDOMException, IOException {
        Element root;
        Document doc;
        if (deploymentFile.exists()) {
            SAXBuilder builder = new SAXBuilder();
            doc = builder.build(deploymentFile);
            root = doc.getRootElement();
        } else {
            doc = new Document();
            root = new Element("datasources");
            doc.setRootElement(root);
        }
        if (!root.getName().equals("datasources")) {
            throw new RuntimeException("Datasource file format exception on [" + deploymentFile + "], expected [datasources] element but found [" + root.getName() + "]");
        }
        Element datasourceElement = DatasourceConfigurationEditor.findDatasourceElement(root, name);
        String type = config.getSimpleValue("type", null);
        boolean isNewDatasource = false;
        if (datasourceElement == null) {
            datasourceElement = new Element(type);
            isNewDatasource = true;
        } else if (!type.equals(datasourceElement.getName())) {
            datasourceElement.setName(type);
        }
        DatasourceConfigurationEditor.updateElements(datasourceElement, config, COMMON_PROPS);
        if (type.equals(XA_TX_TYPE)) {
            DatasourceConfigurationEditor.updateElements(datasourceElement, config, XA_PROPS);
            DatasourceConfigurationEditor.updateMap(datasourceElement, config, "xa-datasource-property");
        } else {
            DatasourceConfigurationEditor.updateElements(datasourceElement, config, NON_XA_PROPS);
            DatasourceConfigurationEditor.updateMap(datasourceElement, config, "connection-property");
        }
        if (isNewDatasource) {
            root.addContent((Content)datasourceElement);
        }
        DatasourceConfigurationEditor.updateFile(deploymentFile, doc);
    }

    public static void deleteDataSource(File deploymentFile, String name) {
        if (deploymentFile.exists()) {
            try {
                SAXBuilder builder = new SAXBuilder();
                Document doc = builder.build(deploymentFile);
                Element root = doc.getRootElement();
                if (root != null) {
                    if (!root.getName().equals("datasources")) {
                        throw new RuntimeException("Datasource file format exception on [" + deploymentFile + "], expected [datasources] element but found [" + root.getName() + "]");
                    }
                    Element datasourceElement = DatasourceConfigurationEditor.findDatasourceElement(root, name);
                    root.removeContent((Content)datasourceElement);
                }
                DatasourceConfigurationEditor.updateFile(deploymentFile, doc);
            }
            catch (JDOMException e) {
                log.error((Object)("Parsing error occurred while deleting datasource at file: " + deploymentFile), (Throwable)e);
            }
            catch (IOException e) {
                log.error((Object)("IO error occurred while deleting datasource at file: " + deploymentFile), (Throwable)e);
            }
        }
    }

    private static void updateMap(Element parent, Configuration configuration, String name) {
        PropertyMap map = configuration.getMap(name);
        ArrayList mapElements = new ArrayList(parent.getChildren(name));
        if (map == null || map.getMap().isEmpty()) {
            if (!mapElements.isEmpty()) {
                parent.removeChildren(name);
            }
            return;
        }
        HashMap<String, Element> elements = new HashMap<String, Element>();
        for (Element el : mapElements) {
            elements.put(el.getAttributeValue("name"), el);
            if (map.get(el.getAttributeValue("name")) != null) continue;
            parent.removeContent((Content)el);
        }
        for (Property prop : map.getMap().values()) {
            Element element = (Element)elements.get(prop.getName());
            if (element == null) {
                element = new Element(name);
                element.setAttribute("name", prop.getName());
                parent.addContent((Content)element);
            }
            element.setText(((PropertySimple)prop).getStringValue());
        }
    }

    private static void updateElements(Element parent, Configuration config, String[] names) {
        for (String prop : names) {
            DatasourceConfigurationEditor.updateElement(parent, config, prop);
        }
    }

    private static void updateElement(Element parent, Configuration config, String name) {
        String value = config.getSimpleValue(name, null);
        Element child = parent.getChild(name);
        if (value == null) {
            if (child != null) {
                parent.removeContent((Content)child);
            }
        } else {
            if (child == null) {
                child = new Element(name);
                parent.addContent((Content)child);
            }
            child.setText(value);
        }
    }

    private static void bindMap(Element parent, Configuration config, String mapName) {
        PropertyMap map = new PropertyMap(mapName);
        for (Object child : parent.getChildren(mapName)) {
            Element childElement = (Element)child;
            String name = childElement.getAttributeValue("name");
            map.put((Property)new PropertySimple(name, (Object)childElement.getText()));
        }
        config.put((Property)map);
    }

    private static void bindElements(Element parent, Configuration config, String[] names) {
        for (String prop : names) {
            DatasourceConfigurationEditor.bindElement(parent, config, prop);
        }
    }

    private static void bindElement(Element parent, Configuration config, String name) {
        Element child = parent.getChild(name);
        if (child != null) {
            config.put((Property)new PropertySimple(name, (Object)child.getText()));
        }
    }

    private static Element findDatasourceElement(Element root, String name) {
        for (Object child : root.getChildren()) {
            Element childElement = (Element)child;
            String jndiName = childElement.getChildText("jndi-name");
            if (!name.equals(jndiName)) continue;
            return childElement;
        }
        return null;
    }

    private static void updateFile(File deploymentFile, Document doc) throws JDOMException, IOException {
        FileOutputStream fos = new FileOutputStream(deploymentFile);
        XMLOutputter outp = new XMLOutputter(Format.getPrettyFormat());
        outp.output(doc, (OutputStream)fos);
        fos.flush();
        fos.close();
    }
}

