/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import org.rhq.core.domain.content.PackageDetails;
import org.rhq.core.domain.content.PackageDetailsKey;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.plugins.utils.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileContentDelegate {
    protected File directory;
    private String fileEnding;
    private String packageTypeName;

    public FileContentDelegate(File directory, String fileEnding, String packageTypeName) {
        this.directory = directory;
        this.fileEnding = fileEnding;
        this.packageTypeName = packageTypeName;
    }

    public String getFileEnding() {
        return this.fileEnding;
    }

    public String getPackageTypeName() {
        return this.packageTypeName;
    }

    public File getDirectory() {
        return this.directory;
    }

    public void createContent(PackageDetails details, InputStream content, boolean unzip) {
        PackageDetailsKey key = details.getKey();
        String fileName = key.getName();
        int lastPathStart = fileName.lastIndexOf(File.separatorChar);
        if (lastPathStart > -1) {
            fileName = fileName.substring(lastPathStart + 1);
        }
        if (!fileName.endsWith(this.fileEnding)) {
            fileName = fileName + this.fileEnding;
        }
        try {
            if (unzip) {
                File outputDir = new File(this.directory.getAbsolutePath() + File.separator + fileName + File.separator);
                FileUtils.unzipFile((InputStream)content, (File)outputDir);
            } else {
                File contentFile = new File(this.directory, fileName);
                FileUtils.writeFile((InputStream)content, (File)contentFile);
            }
            details.setFileName(fileName);
        }
        catch (IOException e) {
            throw new RuntimeException("Error creating artifact from details: " + fileName, e);
        }
    }

    public InputStream getContent(PackageDetails details) {
        PackageDetailsKey key = details.getKey();
        File contentFile = new File(this.directory, key.getName());
        try {
            return new BufferedInputStream(new FileInputStream(contentFile));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Package content not found for package " + key.getName(), e);
        }
    }

    public void deleteContent(PackageDetails details) {
        boolean deleteResult;
        PackageDetailsKey key = details.getKey();
        File contentFile = new File(this.directory, key.getName());
        if (!contentFile.exists()) {
            return;
        }
        if (contentFile.isDirectory()) {
            FileUtils.deleteDirectoryContents((File[])contentFile.listFiles());
        }
        if (!(deleteResult = contentFile.delete())) {
            throw new RuntimeException("Package content not succesfully deleted: " + key.getName());
        }
    }

    public Set<ResourcePackageDetails> discoverDeployedPackages() {
        return null;
    }
}

