/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas.util;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.content.PackageDetailsKey;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.plugins.jbossas.util.FileContentDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarContentDelegate
extends FileContentDelegate {
    public static final String MIME_TYPE_JAR = "application/java-archive";

    public JarContentDelegate(File directory, String typeName) {
        super(directory, ".jar", typeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ResourcePackageDetails> discoverDeployedPackages() {
        File[] files;
        HashSet<ResourcePackageDetails> packages = new HashSet<ResourcePackageDetails>();
        for (File file : files = this.directory.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getName().endsWith(JarContentDelegate.this.getFileEnding()) && pathname.isFile();
            }
        })) {
            ZipFile jf = null;
            try {
                Configuration config = new Configuration();
                jf = new JarFile(file);
                String version = ((JarFile)jf).getManifest().getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                config.put((Property)new PropertySimple("version", (Object)version));
                config.put((Property)new PropertySimple("title", (Object)((JarFile)jf).getManifest().getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_TITLE)));
                config.put((Property)new PropertySimple("url", (Object)((JarFile)jf).getManifest().getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_URL)));
                config.put((Property)new PropertySimple("vendor", (Object)((JarFile)jf).getManifest().getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VENDOR)));
                config.put((Property)new PropertySimple("classpath", (Object)((JarFile)jf).getManifest().getMainAttributes().getValue(Attributes.Name.CLASS_PATH)));
                config.put((Property)new PropertySimple("sealed", (Object)((JarFile)jf).getManifest().getMainAttributes().getValue(Attributes.Name.SEALED)));
                if (version == null) {
                    version = "1.0";
                }
                ResourcePackageDetails details = new ResourcePackageDetails(new PackageDetailsKey(file.getName(), version, this.getPackageTypeName(), "noarch"));
                packages.add(details);
                details.setFileCreatedDate(Long.valueOf(file.lastModified()));
                details.setFileName(file.getName());
                details.setFileSize(Long.valueOf(file.length()));
                details.setClassification(MIME_TYPE_JAR);
                details.setExtraProperties(config);
            }
            catch (IOException e) {
            }
            finally {
                try {
                    jf.close();
                }
                catch (Exception e) {}
            }
        }
        return packages;
    }
}

