/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas.util;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mc4j.ems.connection.EmsConnection;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.plugins.jbossas.JBossASServerComponent;
import org.rhq.plugins.jbossas.util.DeploymentUtility;
import org.rhq.plugins.jbossas.util.WarDeploymentInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WarDiscoveryHelper {
    private static final Log LOG = LogFactory.getLog(WarDiscoveryHelper.class);
    public static final String JBOSS_WEB_MBEAN_NAME_TEMPLATE = "jboss.web:J2EEApplication=none,J2EEServer=none,j2eeType=WebModule,name=%name%";
    private static final String ROOT_WEBAPP_RT_LOG_FILE_NAME_BASE = "ROOT";
    private static final String RT_LOG_FILE_NAME_SUFFIX = "_rt.log";
    private static final String WEB_SERVICES_EJB_WAR_FILE_NAME_REGEX = "\\.(ejb|jar)\\d+\\.war$";
    private static final Pattern WEB_SERVICES_EJB_WAR_FILE_NAME_PATTERN = Pattern.compile("\\.(ejb|jar)\\d+\\.war$");
    private static final String ROOT_WEBAPP_RESOURCE_NAME = "ROOT.war";

    private WarDiscoveryHelper() {
    }

    public static Set<DiscoveredResourceDetails> initPluginConfigurations(JBossASServerComponent parentJBossASComponent, Set<DiscoveredResourceDetails> warResources) {
        EmsConnection jmxConnection = parentJBossASComponent.getEmsConnection();
        File configPath = parentJBossASComponent.getConfigurationPath();
        File logDir = new File(configPath, "log");
        File rtLogDir = new File(logDir, "rt");
        ArrayList<String> objectNames = new ArrayList<String>();
        for (DiscoveredResourceDetails resourceDetails : warResources) {
            Configuration warConfig = resourceDetails.getPluginConfiguration();
            PropertySimple objectNameProperty = warConfig.getSimple("objectName");
            objectNames.add(objectNameProperty.getStringValue());
        }
        Map<String, List<WarDeploymentInformation>> deploymentInformations = DeploymentUtility.getWarDeploymentInformation(jmxConnection, objectNames);
        HashSet<DiscoveredResourceDetails> resultingResources = new HashSet<DiscoveredResourceDetails>();
        Iterator<DiscoveredResourceDetails> warResourcesIterator = warResources.iterator();
        while (warResourcesIterator.hasNext()) {
            DiscoveredResourceDetails discoResDetail = warResourcesIterator.next();
            Configuration warConfig = discoResDetail.getPluginConfiguration();
            PropertySimple objectNameProperty = warConfig.getSimple("objectName");
            List<WarDeploymentInformation> deploymentInfoList = null;
            if (deploymentInformations != null) {
                deploymentInfoList = deploymentInformations.get(objectNameProperty.getStringValue());
            }
            if (deploymentInfoList != null) {
                for (WarDeploymentInformation info : deploymentInfoList) {
                    Configuration configClone;
                    String vhost = info.getVHost();
                    if ("localhost".equals(vhost)) {
                        WarDiscoveryHelper.initPluginConfiguration(info, rtLogDir, warResourcesIterator, discoResDetail);
                        resultingResources.add(discoResDetail);
                        continue;
                    }
                    String key = discoResDetail.getResourceKey();
                    key = key + ",vhost=" + vhost;
                    try {
                        configClone = discoResDetail.getPluginConfiguration().clone();
                    }
                    catch (CloneNotSupportedException e) {
                        e.printStackTrace();
                        configClone = new Configuration();
                    }
                    DiscoveredResourceDetails myDetail = new DiscoveredResourceDetails(discoResDetail.getResourceType(), key, discoResDetail.getResourceName(), discoResDetail.getResourceVersion(), discoResDetail.getResourceDescription() + " on (" + vhost + ")", configClone, discoResDetail.getProcessInfo());
                    WarDiscoveryHelper.initPluginConfiguration(info, rtLogDir, warResourcesIterator, myDetail);
                    resultingResources.add(myDetail);
                }
                continue;
            }
            warResourcesIterator.remove();
            if (discoResDetail.getResourceName().equals(ROOT_WEBAPP_RESOURCE_NAME)) continue;
            LOG.debug((Object)("The deployed WAR '" + discoResDetail.getResourceName() + "' does not have a jboss.web MBean (i.e. context root) associated with it; it will not be added to inventory."));
        }
        return resultingResources;
    }

    public static void setDeploymentInformation(Configuration pluginConfig, WarDeploymentInformation deploymentInformation) {
        pluginConfig.put((Property)new PropertySimple("jbossWebName", (Object)deploymentInformation.getJbossWebModuleMBeanObjectName()));
        pluginConfig.put((Property)new PropertySimple("contextRoot", (Object)deploymentInformation.getContextRoot()));
        pluginConfig.put((Property)new PropertySimple("vHost", (Object)deploymentInformation.getVHost()));
    }

    public static String getContextPath(String contextRoot) {
        return contextRoot.equals("/") ? "/" : "/" + contextRoot;
    }

    private static void initPluginConfiguration(WarDeploymentInformation deploymentInformation, File rtLogDir, Iterator<DiscoveredResourceDetails> warResourcesIterator, DiscoveredResourceDetails resource) {
        Configuration pluginConfig = resource.getPluginConfiguration();
        String warFileName = resource.getResourceName();
        String contextRoot = deploymentInformation.getContextRoot();
        int length = contextRoot.length();
        if (length > 0 && contextRoot.charAt(length - 1) == '.' && WEB_SERVICES_EJB_WAR_FILE_NAME_PATTERN.matcher(warFileName).find()) {
            warResourcesIterator.remove();
            return;
        }
        WarDiscoveryHelper.setDeploymentInformation(pluginConfig, deploymentInformation);
        String rtLogFileNameBase = contextRoot.equals("/") ? ROOT_WEBAPP_RT_LOG_FILE_NAME_BASE : contextRoot;
        String vHost = deploymentInformation.getVHost();
        vHost = "localhost".equals(vHost) ? "" : vHost + "_";
        String rtLogFileName = vHost + rtLogFileNameBase + RT_LOG_FILE_NAME_SUFFIX;
        File rtLogFile = new File(rtLogDir, rtLogFileName);
        pluginConfig.put((Property)new PropertySimple("responseTimeLogFile", (Object)rtLogFile));
    }
}

