/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.examples.consumer;

import org.odata4j.consumer.ODataConsumer;
import org.odata4j.consumer.ODataConsumers;
import org.odata4j.core.OEntity;
import org.odata4j.core.OObject;
import org.odata4j.core.OProperties;
import org.odata4j.core.OProperty;
import org.odata4j.examples.AbstractExample;

public class LightSwitchExample
extends AbstractExample {
    public static void main(String[] args) {
        String serviceUrl = "http://localhost:5076/ApplicationData.svc/";
        String entitySet = "Customers";
        String propertyName = "Name";
        ODataConsumer c = ODataConsumers.newBuilder((String)serviceUrl).build();
        LightSwitchExample.reportMetadata(c.getMetadata());
        LightSwitchExample.reportEntities(c, "Customers", 50);
        OEntity newCustomer = (OEntity)c.createEntity(entitySet).properties(new OProperty[]{OProperties.string((String)propertyName, (String)"New name")}).execute();
        LightSwitchExample.reportEntity("created", newCustomer);
        c.mergeEntity(newCustomer).properties(new OProperty[]{OProperties.string((String)propertyName, (String)"Merged Name")}).execute();
        newCustomer = (OEntity)c.getEntity(entitySet, newCustomer.getEntityKey()).execute();
        LightSwitchExample.reportEntity("merged and got", newCustomer);
        c.updateEntity(newCustomer).properties(new OProperty[]{OProperties.string((String)propertyName, (String)"Updated Name")}).execute();
        newCustomer = (OEntity)c.getEntity(entitySet, newCustomer.getEntityKey()).execute();
        LightSwitchExample.reportEntity("updated and got", newCustomer);
        c.deleteEntity(newCustomer).execute();
        LightSwitchExample.report("deleted");
        OObject rt = (OObject)c.callFunction("Microsoft_LightSwitch_GetCanInformation").pString("dataServiceMembers", entitySet).execute().iterator().next();
        LightSwitchExample.report("GetCanInformation for %s: %s", entitySet, rt);
    }
}

