/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.examples.consumer;

import org.joda.time.LocalDateTime;
import org.odata4j.consumer.ODataConsumer;
import org.odata4j.consumer.ODataConsumers;
import org.odata4j.core.OEntity;
import org.odata4j.core.OFuncs;
import org.odata4j.core.OProperties;
import org.odata4j.core.OProperty;
import org.odata4j.examples.AbstractExample;
import org.odata4j.exceptions.NotFoundException;
import org.odata4j.exceptions.ODataProducerException;

public class ODataTestServiceReadWriteExample
extends AbstractExample {
    public static void main(String[] args) {
        ODataTestServiceReadWriteExample example = new ODataTestServiceReadWriteExample();
        example.run(args);
    }

    private void run(String[] args) {
        boolean exists;
        block5: {
            ODataConsumer c = ODataConsumers.create((String)"http://services.odata.org/(S(mvnfyllpw41mbzvkme0o0zug))/OData/OData.svc/");
            ODataTestServiceReadWriteExample.reportMetadata(c.getMetadata());
            OEntity havinaCola = (OEntity)c.getEntity("Products", (Object)3).execute();
            ODataTestServiceReadWriteExample.reportEntity("Havina Cola", havinaCola);
            for (OEntity product : c.getEntities("Products").execute()) {
                ODataTestServiceReadWriteExample.reportEntity("Product: " + product.getProperty("Name").getValue(), product);
            }
            OEntity dvdPlayer = (OEntity)c.getEntities("Products").filter("Description eq '1080P Upconversion DVD Player'").top(1).execute().first();
            ODataTestServiceReadWriteExample.reportEntity("DVD Player", dvdPlayer);
            try {
                c.deleteEntity("Products", (Object)10).execute();
            }
            catch (NotFoundException e) {
                // empty catch block
            }
            OEntity newProduct = (OEntity)c.createEntity("Products").properties(new OProperty[]{OProperties.int32((String)"ID", (Integer)10)}).properties(new OProperty[]{OProperties.string((String)"Name", (String)"Josta")}).properties(new OProperty[]{OProperties.string((String)"Description", (String)"With guaran\u00e1")}).properties(new OProperty[]{OProperties.datetime((String)"ReleaseDate", (LocalDateTime)new LocalDateTime())}).properties(new OProperty[]{OProperties.int32((String)"Rating", (Integer)1)}).properties(new OProperty[]{OProperties.decimal((String)"Price", (double)1.23)}).execute();
            ODataTestServiceReadWriteExample.report("newProduct: " + newProduct);
            c.updateEntity(newProduct).properties(new OProperty[]{OProperties.int32((String)"Rating", (Integer)5)}).execute();
            ODataTestServiceReadWriteExample.report("newProduct rating after update: " + ((OEntity)c.getEntity("Products", (Object)10).execute()).getProperty("Rating").getValue());
            c.mergeEntity("Products", (Object)10).properties(new OProperty[]{OProperties.int32((String)"Rating", (Integer)500)}).execute();
            ODataTestServiceReadWriteExample.report("newProduct rating after merge: " + ((OEntity)c.getEntity("Products", (Object)10).execute()).getProperty("Rating").getValue());
            ODataTestServiceReadWriteExample.report("highest rated product (compute on server): " + c.getEntities("Products").orderBy("Rating desc").top(1).execute().first());
            ODataTestServiceReadWriteExample.report("highest rated product (compute on client): " + c.getEntities("Products").execute().orderBy(OFuncs.entityPropertyValue((String)"Rating", Integer.class)).last());
            c.deleteEntity("Products", (Object)10).execute();
            exists = true;
            try {
                c.getEntity("Products", (Object)10).execute();
            }
            catch (ODataProducerException e) {
                if (e.getHttpStatus().getStatusCode() != 404) break block5;
                exists = false;
            }
        }
        ODataTestServiceReadWriteExample.report("newProduct " + (exists ? "exists" : "does not exist"));
    }
}

