/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.examples.consumer;

import org.core4j.Enumerable;
import org.odata4j.consumer.ODataConsumer;
import org.odata4j.consumer.ODataConsumers;
import org.odata4j.core.EntitySetInfo;
import org.odata4j.core.OEntity;
import org.odata4j.examples.AbstractExample;

public class ServiceListingConsumerExample
extends AbstractExample {
    public static void main(String[] args) {
        ServiceListingConsumerExample example = new ServiceListingConsumerExample();
        example.run(args);
    }

    private void run(String[] args) {
        ODataConsumer.dump.requestHeaders(true);
        Enumerable smallServices = Enumerable.create((Object[])new String[]{"http://services.odata.org/Northwind/Northwind.svc/", "http://odata4j-sample.appspot.com/datastore.svc/", "http://services.odata.org/website/odata.svc/", "http://services.odata.org/OData/OData.svc/", "http://www.nerddinner.com/Services/OData.svc/", "http://odata.msteched.com/sessions.svc/", "http://odata.msteched.com/teeu10/sessions.svc/", "http://tv.telerik.com/services/odata.svc/", "http://proagora.com/fr/odata/", "http://proagora.com/en/odata/"});
        Enumerable largeServices = Enumerable.create((Object[])new String[]{"http://www.baseball-stats.info/OData/BaseballStats.svc/", "http://odata.netflix.com/Catalog/", "http://www.openligadb.de/Webservices/OData.svc/", "http://packages.nuget.org/v1/FeedService.svc/"});
        this.printOutAllEntities((Iterable<String>)smallServices);
        this.printOutFirstEntities((Iterable<String>)largeServices);
    }

    private void printOutFirstEntities(Iterable<String> services) {
        for (String endpoint : services) {
            ODataConsumer c = ODataConsumers.create((String)endpoint);
            for (EntitySetInfo entitySet : c.getEntitySets()) {
                ServiceListingConsumerExample.reportEntities(entitySet.getHref(), (Enumerable<OEntity>)c.getEntities(entitySet.getHref()).top(1).execute());
            }
        }
    }

    private void printOutAllEntities(Iterable<String> services) {
        for (String endpoint : services) {
            ODataConsumer c = ODataConsumers.create((String)endpoint);
            for (EntitySetInfo entitySet : c.getEntitySets()) {
                ServiceListingConsumerExample.reportEntities(entitySet.getTitle(), (Enumerable<OEntity>)c.getEntities(entitySet.getHref()).execute());
            }
        }
    }
}

