/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.examples.jersey.producer.server;

import com.sun.jersey.api.container.ContainerFactory;
import com.sun.jersey.api.container.httpserver.HttpServerFactory;
import com.sun.jersey.api.core.ApplicationAdapter;
import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.server.impl.provider.RuntimeDelegateImpl;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import com.sun.jersey.spi.container.ContainerResponseFilter;
import com.sun.jersey.spi.container.ResourceFilterFactory;
import com.sun.net.httpserver.Authenticator;
import com.sun.net.httpserver.Filter;
import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.RuntimeDelegate;
import org.core4j.CoreUtils;
import org.core4j.Enumerable;
import org.odata4j.core.Throwables;
import org.odata4j.producer.server.ODataServer;

public class ODataJerseyServer
implements ODataServer {
    private static final Logger LOG = Logger.getLogger(ODataJerseyServer.class.getName());
    private final String appBaseUri;
    private Class<? extends Application> odataApp;
    private Class<? extends Application> rootApp;
    private final List<String> jerseyRequestFilters = new ArrayList<String>();
    private final List<String> jerseyResponseFilters = new ArrayList<String>();
    private final List<String> jerseyResourceFilters = new ArrayList<String>();
    private final Map<String, Boolean> jerseyFeatures = new HashMap<String, Boolean>();
    private final List<Filter> httpServerFilters = new ArrayList<Filter>();
    private Authenticator httpServerAuthenticator;
    private HttpServer server;

    public ODataJerseyServer(String appBaseUri) {
        this.appBaseUri = appBaseUri;
        if (!(RuntimeDelegate.getInstance() instanceof RuntimeDelegateImpl)) {
            RuntimeDelegate.setInstance((RuntimeDelegate)new RuntimeDelegateImpl());
        }
    }

    public ODataJerseyServer(String appBaseUri, Class<? extends Application> odataApp, Class<? extends Application> rootApp) {
        this(appBaseUri);
        this.odataApp = odataApp;
        this.rootApp = rootApp;
    }

    public ODataServer setODataApplication(Class<? extends Application> odataApp) {
        this.odataApp = odataApp;
        return this;
    }

    public ODataServer setRootApplication(Class<? extends Application> rootApp) {
        this.rootApp = rootApp;
        return this;
    }

    public <T extends ContainerRequestFilter> ODataJerseyServer addJerseyRequestFilter(Class<T> filter) {
        this.jerseyRequestFilters.add(filter.getName());
        return this;
    }

    public <T extends ContainerResponseFilter> ODataJerseyServer addJerseyResponseFilter(Class<T> filter) {
        this.jerseyResponseFilters.add(filter.getName());
        return this;
    }

    public <T extends ResourceFilterFactory> ODataJerseyServer addJerseyResourceFilter(Class<T> filter) {
        this.jerseyResourceFilters.add(filter.getName());
        return this;
    }

    public ODataJerseyServer setJerseyTrace(boolean enabled) {
        return this.setJerseyFeature("com.sun.jersey.config.feature.Trace", enabled);
    }

    public ODataJerseyServer setJerseyFeature(String feature, boolean value) {
        this.jerseyFeatures.put(feature, value);
        return this;
    }

    public ODataJerseyServer addHttpServerFilter(Filter filter) {
        this.httpServerFilters.add(filter);
        return this;
    }

    public ODataJerseyServer setHttpServerAuthenticator(Authenticator authenticator) {
        this.httpServerAuthenticator = authenticator;
        return this;
    }

    public ODataServer stop() {
        return this.stop(0);
    }

    public ODataJerseyServer stop(int delaySeconds) {
        this.server.stop(delaySeconds);
        Executor serverExecutor = this.server.getExecutor();
        if (serverExecutor instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)serverExecutor).shutdown();
            if (delaySeconds > 0) {
                try {
                    ((ThreadPoolExecutor)serverExecutor).awaitTermination(delaySeconds, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return this;
    }

    public ODataServer start() {
        if (this.odataApp == null) {
            throw new RuntimeException("ODataApplication not set");
        }
        try {
            Map<String, Object> propertiesAndFeatures = this.buildPropertiesAndFeatures();
            ApplicationAdapter odataAppAdapter = new ApplicationAdapter(this.odataApp.newInstance());
            odataAppAdapter.setPropertiesAndFeatures(propertiesAndFeatures);
            this.server = HttpServerFactory.create((String)this.appBaseUri, (ResourceConfig)odataAppAdapter);
            if (this.rootApp != null) {
                ApplicationAdapter rootAppAdapter = new ApplicationAdapter(this.rootApp.newInstance());
                rootAppAdapter.setPropertiesAndFeatures(propertiesAndFeatures);
                HttpHandler rootHttpHandler = (HttpHandler)ContainerFactory.createContainer(HttpHandler.class, (ResourceConfig)rootAppAdapter);
                this.server.createContext("/", rootHttpHandler);
            }
            for (HttpContext context : this.getHttpContexts()) {
                this.initHttpContext(context);
            }
            this.server.start();
            LOG.info(String.format("Jersey app started with WADL available at %sapplication.wadl\n", this.appBaseUri));
            return this;
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (InstantiationException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    protected HttpServer getHttpServer() {
        return this.server;
    }

    protected Map<String, Object> buildPropertiesAndFeatures() {
        HashMap<String, Object> propertiesAndFeatures = new HashMap<String, Object>();
        propertiesAndFeatures.put("com.sun.jersey.spi.container.ContainerRequestFilters", Enumerable.create(this.jerseyRequestFilters).toArray(String.class));
        propertiesAndFeatures.put("com.sun.jersey.spi.container.ContainerResponseFilters", Enumerable.create(this.jerseyResponseFilters).toArray(String.class));
        propertiesAndFeatures.put("com.sun.jersey.spi.container.ResourceFilters", Enumerable.create(this.jerseyResourceFilters).toArray(String.class));
        propertiesAndFeatures.putAll(this.jerseyFeatures);
        return propertiesAndFeatures;
    }

    protected void initHttpContext(HttpContext context) {
        context.getFilters().addAll(this.httpServerFilters);
        if (this.httpServerAuthenticator != null) {
            context.setAuthenticator(this.httpServerAuthenticator);
        }
    }

    protected Iterable<HttpContext> getHttpContexts() {
        Object tmp = CoreUtils.getFieldValue((Object)this.server, (String)"server", Object.class);
        tmp = CoreUtils.getFieldValue((Object)tmp, (String)"contexts", Object.class);
        tmp = CoreUtils.getFieldValue((Object)tmp, (String)"list", Object.class);
        return (List)tmp;
    }
}

