/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.examples.producer.inmemory;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.core4j.Enumerable;
import org.core4j.Enumerables;
import org.core4j.Func;
import org.core4j.Func1;
import org.core4j.Funcs;
import org.core4j.ThrowingFunc;
import org.odata4j.core.NamespacedAnnotation;
import org.odata4j.core.OCollection;
import org.odata4j.core.OCollections;
import org.odata4j.core.OComplexObject;
import org.odata4j.core.OComplexObjects;
import org.odata4j.core.OObject;
import org.odata4j.core.OProperties;
import org.odata4j.core.OProperty;
import org.odata4j.core.OSimpleObjects;
import org.odata4j.core.PrefixedNamespace;
import org.odata4j.edm.EdmAnnotation;
import org.odata4j.edm.EdmAnnotationAttribute;
import org.odata4j.edm.EdmComplexType;
import org.odata4j.edm.EdmDecorator;
import org.odata4j.edm.EdmDocumentation;
import org.odata4j.edm.EdmEntitySet;
import org.odata4j.edm.EdmEntityType;
import org.odata4j.edm.EdmItem;
import org.odata4j.edm.EdmProperty;
import org.odata4j.edm.EdmSimpleType;
import org.odata4j.edm.EdmStructuralType;
import org.odata4j.edm.EdmType;
import org.odata4j.examples.AbstractExample;
import org.odata4j.examples.JaxRsImplementation;
import org.odata4j.examples.ODataServerFactory;
import org.odata4j.producer.ODataProducer;
import org.odata4j.producer.PropertyPath;
import org.odata4j.producer.inmemory.InMemoryProducer;
import org.odata4j.producer.resources.DefaultODataProducerProvider;

public class InMemoryProducerExample
extends AbstractExample {
    public static void main(String[] args) {
        InMemoryProducerExample example = new InMemoryProducerExample();
        example.run(args);
    }

    private void run(String[] args) {
        String endpointUri = "http://localhost:8887/InMemoryProducerExample.svc/";
        final InMemoryProducer producer = new InMemoryProducer("InMemoryProducerExample", null, 100, (EdmDecorator)new MyEdmDecorator(), null);
        producer.register(Thread.class, "Threads", (Func)new Func<Iterable<Thread>>(){

            public Iterable<Thread> apply() {
                ThreadGroup tg = Thread.currentThread().getThreadGroup();
                while (tg.getParent() != null) {
                    tg = tg.getParent();
                }
                Object[] threads = new Thread[1000];
                int count = tg.enumerate((Thread[])threads, true);
                return Enumerable.create((Object[])threads).take(count);
            }
        }, new String[]{"Id"});
        producer.register(Map.Entry.class, "SystemProperties", (Func)new Func<Iterable<Map.Entry>>(){

            public Iterable<Map.Entry> apply() {
                return System.getProperties().entrySet();
            }
        }, new String[]{"Key"});
        producer.register(Map.Entry.class, "EnvironmentVariables", (Func)new Func<Iterable<Map.Entry>>(){

            public Iterable<Map.Entry> apply() {
                return System.getenv().entrySet();
            }
        }, new String[]{"Key"});
        producer.register(EdmEntityType.class, "EdmEntityTypes", (Func)new Func<Iterable<EdmEntityType>>(){

            public Iterable<EdmEntityType> apply() {
                return producer.getMetadata().getEntityTypes();
            }
        }, new String[]{"FullyQualifiedTypeName"});
        producer.register(EtfInfo.class, "ETFs", Funcs.wrap((ThrowingFunc)new ThrowingFunc<Iterable<EtfInfo>>(){

            public Iterable<EtfInfo> apply() throws Exception {
                return InMemoryProducerExample.getETFs();
            }
        }), new String[]{"Symbol"});
        producer.register(Integer.class, Integer.class, "Integers", (Func)new Func<Iterable<Integer>>(){

            public Iterable<Integer> apply() {
                return Enumerable.range((int)0, (int)Integer.MAX_VALUE);
            }
        }, Funcs.method(Integer.class, Integer.class, (String)"intValue"));
        DefaultODataProducerProvider.setInstance((ODataProducer)producer);
        new ODataServerFactory(JaxRsImplementation.JERSEY).hostODataServer(endpointUri);
    }

    private static Iterable<EtfInfo> getETFs() throws Exception {
        return Enumerables.lines((URL)new URL("http://www.masterdata.com/HelpFiles/ETF_List_Downloads/AllETFs.csv")).select((Func1)new Func1<String, EtfInfo>(){

            public EtfInfo apply(String csvLine) {
                return EtfInfo.parse(csvLine);
            }
        }).skip(1);
    }

    public static class MyEdmDecorator
    implements EdmDecorator {
        public static final String namespace = "http://tempuri.org";
        public static final String prefix = "inmem";
        private final List<PrefixedNamespace> namespaces = new ArrayList<PrefixedNamespace>(1);
        private final EdmComplexType schemaInfoType;

        public MyEdmDecorator() {
            this.namespaces.add(new PrefixedNamespace(namespace, prefix));
            this.schemaInfoType = this.createSchemaInfoType().build();
        }

        public List<PrefixedNamespace> getNamespaces() {
            return this.namespaces;
        }

        public EdmDocumentation getDocumentationForSchema(String namespace) {
            return new EdmDocumentation("InMemoryProducerExample", "This schema exposes a few example types to demonstrate the InMemoryProducer");
        }

        private EdmComplexType.Builder createSchemaInfoType() {
            ArrayList<EdmProperty.Builder> props = new ArrayList<EdmProperty.Builder>();
            EdmProperty.Builder ep = EdmProperty.newBuilder((String)"Author").setType((EdmType)EdmSimpleType.STRING);
            props.add(ep);
            ep = EdmProperty.newBuilder((String)"SeeAlso").setType((EdmType)EdmSimpleType.STRING);
            props.add(ep);
            return (EdmComplexType.Builder)((EdmComplexType.Builder)((EdmComplexType.Builder)EdmComplexType.newBuilder().setNamespace(namespace)).setName("SchemaInfo")).addProperties(props);
        }

        public List<EdmAnnotation<?>> getAnnotationsForSchema(String namespace) {
            ArrayList annots = new ArrayList();
            annots.add((EdmAnnotation<?>)new EdmAnnotationAttribute(namespace, prefix, "Version", "1.0 early experience pre-alpha"));
            ArrayList<OProperty> p = new ArrayList<OProperty>();
            p.add(OProperties.string((String)"Author", (String)"Xavier S. Dumont"));
            p.add(OProperties.string((String)"SeeAlso", (String)"InMemoryProducerExample.java"));
            annots.add((EdmAnnotation<?>)EdmAnnotation.element((String)namespace, (String)prefix, (String)"SchemaInfo", OComplexObject.class, (Object)OComplexObjects.create((EdmComplexType)this.schemaInfoType, p)));
            annots.add((EdmAnnotation<?>)EdmAnnotation.element((String)namespace, (String)prefix, (String)"Tags", OCollection.class, (Object)OCollections.newBuilder((EdmType)EdmSimpleType.STRING).add((OObject)OSimpleObjects.create((EdmSimpleType)EdmSimpleType.STRING, (Object)"tag1")).add((OObject)OSimpleObjects.create((EdmSimpleType)EdmSimpleType.STRING, (Object)"tag2")).build()));
            return annots;
        }

        public EdmDocumentation getDocumentationForEntityType(String namespace, String typeName) {
            return null;
        }

        public List<EdmAnnotation<?>> getAnnotationsForEntityType(String namespace, String typeName) {
            return null;
        }

        public Object resolveStructuralTypeProperty(EdmStructuralType st, PropertyPath path) throws IllegalArgumentException {
            return null;
        }

        public EdmDocumentation getDocumentationForProperty(String namespace, String typename, String propName) {
            return null;
        }

        public List<EdmAnnotation<?>> getAnnotationsForProperty(String namespace, String typename, String propName) {
            return null;
        }

        public Object resolvePropertyProperty(EdmProperty st, PropertyPath path) throws IllegalArgumentException {
            return null;
        }

        public Object getAnnotationValueOverride(EdmItem item, NamespacedAnnotation<?> annot, boolean flatten, Locale locale, Map<String, String> options) {
            return null;
        }

        public void decorateEntity(EdmEntitySet entitySet, EdmItem item, EdmItem originalQueryItem, List<OProperty<?>> props, boolean flatten, Locale locale, Map<String, String> options) {
        }
    }

    public static class EtfInfo {
        private final String name;
        private final String symbol;
        private final String fundType;

        private EtfInfo(String name, String symbol, String fundType) {
            this.name = name;
            this.symbol = symbol;
            this.fundType = fundType;
        }

        public static EtfInfo parse(String csvLine) {
            csvLine = csvLine.substring(0, csvLine.lastIndexOf(44));
            int i = csvLine.lastIndexOf(44);
            String type = csvLine.substring(i + 1);
            csvLine = csvLine.substring(0, csvLine.lastIndexOf(44));
            i = csvLine.lastIndexOf(44);
            String sym = csvLine.substring(i + 1);
            String name = csvLine = csvLine.substring(0, csvLine.lastIndexOf(44));
            name = name.startsWith("\"") ? name.substring(1) : name;
            name = name.endsWith("\"") ? name.substring(0, name.length() - 1) : name;
            name = name.replace("\u00a0", " ");
            return new EtfInfo(name, sym, type);
        }

        public String getName() {
            return this.name;
        }

        public String getSymbol() {
            return this.symbol;
        }

        public String getFundType() {
            return this.fundType;
        }
    }
}

