/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.examples.producer.inmemory;

import java.util.ArrayList;
import org.core4j.Enumerable;
import org.core4j.Func;
import org.odata4j.consumer.ODataConsumer;
import org.odata4j.consumer.ODataConsumers;
import org.odata4j.core.OEntity;
import org.odata4j.examples.AbstractExample;
import org.odata4j.examples.JaxRsImplementation;
import org.odata4j.examples.ODataServerFactory;
import org.odata4j.producer.ODataProducer;
import org.odata4j.producer.inmemory.InMemoryProducer;
import org.odata4j.producer.resources.DefaultODataProducerProvider;
import org.odata4j.producer.server.ODataServer;

public class RoundtripExample
extends AbstractExample {
    public static void main(String[] args) {
        RoundtripExample example = new RoundtripExample();
        example.run(args);
    }

    private void run(String[] args) {
        String endpointUri = "http://localhost:8885/RoundtripExample.svc/";
        InMemoryProducer producer = new InMemoryProducer("RoundtripExample");
        producer.register(Customer.class, "Customers", (Func)new Func<Iterable<Customer>>(){

            public Iterable<Customer> apply() {
                ArrayList<Customer> customers = new ArrayList<Customer>();
                customers.add(new Customer(1, "John"));
                return customers;
            }
        }, new String[]{"Id"});
        DefaultODataProducerProvider.setInstance((ODataProducer)producer);
        ODataServer server = new ODataServerFactory(JaxRsImplementation.JERSEY).startODataServer(endpointUri);
        ODataConsumer.dump.responseHeaders(true);
        ODataConsumer consumer = ODataConsumers.create((String)endpointUri);
        RoundtripExample.reportEntities("Customers", (Enumerable<OEntity>)consumer.getEntities("Customers").execute());
        for (Customer customer : consumer.getEntities(Customer.class, "Customers").execute()) {
            RoundtripExample.report(customer.toString());
        }
        server.stop();
    }

    public static class Customer {
        private int id;
        private String name;

        public Customer() {
        }

        public Customer(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void setId(int id) {
            this.id = id;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String toString() {
            return String.format("Customer[Id=%s,Name=%s]", this.id, this.name);
        }
    }
}

