/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.examples.consumer;

import org.core4j.Enumerable;
import org.odata4j.consumer.ODataConsumer;
import org.odata4j.consumer.ODataConsumers;
import org.odata4j.consumer.behaviors.OClientBehavior;
import org.odata4j.consumer.behaviors.OClientBehaviors;
import org.odata4j.core.OEntity;
import org.odata4j.core.ORelatedEntitiesLink;
import org.odata4j.examples.AbstractExample;

public class CodePlexConsumerExample
extends AbstractExample {
    private static final int MAX_LISTING = 5;

    public static void main(String[] args) {
        CodePlexConsumerExample example = new CodePlexConsumerExample();
        example.run(args);
    }

    private void run(String[] args) {
        ODataConsumer.dump.requestHeaders(true);
        String[] codeplexCreds = args.length > 0 ? args : System.getenv("CODEPLEX").split(":");
        String codeplexUser = "snd\\" + codeplexCreds[0] + "_cp";
        String codeplexPassword = codeplexCreds[1];
        for (String collection : Enumerable.create((Object[])new String[]{"TFS03", "TFS05", "TFS09"})) {
            ODataConsumer c = ODataConsumers.newBuilder((String)("https://codeplexodata.cloudapp.net/" + collection)).setClientBehaviors(new OClientBehavior[]{OClientBehaviors.basicAuth((String)codeplexUser, (String)codeplexPassword)}).build();
            for (OEntity p : c.getEntities("Projects").execute()) {
                CodePlexConsumerExample.reportEntity("project:", p);
                if (((String)p.getProperty("Name", String.class).getValue()).equals("s3")) continue;
                for (OEntity cs : CodePlexConsumerExample.listChildren(c, p, "Changesets")) {
                    CodePlexConsumerExample.reportEntity("changeset:", cs);
                    for (OEntity ch : CodePlexConsumerExample.listChildren(c, cs, "Changes")) {
                        CodePlexConsumerExample.reportEntity("change:", ch);
                    }
                }
                for (OEntity wi : CodePlexConsumerExample.listChildren(c, p, "WorkItems")) {
                    CodePlexConsumerExample.reportEntity("workitem:", wi);
                    for (OEntity a : CodePlexConsumerExample.listChildren(c, wi, "Attachments")) {
                        CodePlexConsumerExample.reportEntity("attachment:", a);
                    }
                }
            }
        }
    }

    private static Iterable<OEntity> listChildren(ODataConsumer c, OEntity parent, String child) {
        return c.getEntities((ORelatedEntitiesLink)parent.getLink(child, ORelatedEntitiesLink.class)).execute().take(5);
    }
}

