/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.examples.consumer;

import org.odata4j.consumer.ODataConsumer;
import org.odata4j.consumer.ODataConsumers;
import org.odata4j.core.OEntity;
import org.odata4j.core.OProperties;
import org.odata4j.core.OProperty;
import org.odata4j.examples.AbstractExample;

public class AppEngineConsumerExample
extends AbstractExample {
    public static void main(String[] args) {
        AppEngineConsumerExample example = new AppEngineConsumerExample();
        example.run(args);
    }

    private void run(String[] args) {
        ODataConsumer c = ODataConsumers.create((String)"http://odata4j-sample.appspot.com/datastore.svc/");
        String newCategoryName = "NewCategory" + System.currentTimeMillis();
        AppEngineConsumerExample.report("Create a new category");
        OEntity newCategory = (OEntity)c.createEntity("Categories").properties(new OProperty[]{OProperties.string((String)"categoryName", (String)newCategoryName)}).properties(new OProperty[]{OProperties.int32((String)"AdditionalProperty", (Integer)500)}).execute();
        AppEngineConsumerExample.reportEntity(newCategoryName, newCategory);
        AppEngineConsumerExample.reportEntities(c, "Categories", 100);
        AppEngineConsumerExample.report("Update the new category");
        c.updateEntity(newCategory).properties(new OProperty[]{OProperties.string((String)"description", (String)"Updated")}).execute();
        AppEngineConsumerExample.reportEntities(c, "Categories", 100);
        AppEngineConsumerExample.report("Merge the new category");
        c.mergeEntity("Categories", (Object)newCategory.getProperty("id")).properties(new OProperty[]{OProperties.string((String)"description", (String)"Merged")}).execute();
        AppEngineConsumerExample.reportEntities(c, "Categories", 100);
        AppEngineConsumerExample.report("Delete the new category");
        c.deleteEntity("Categories", newCategory.getEntityKey()).execute();
        AppEngineConsumerExample.reportEntities(c, "Categories", 100);
        AppEngineConsumerExample.reportEntity("Last category by category name (excluding seafood): ", (OEntity)c.getEntities("Categories").filter("categoryName ne 'Seafood'").orderBy("categoryName desc").top(1).execute().first());
        AppEngineConsumerExample.reportEntity("\nNon-discontinued product with reorderLevel > 25 (two filter predicates): ", (OEntity)c.getEntities("Products").filter("reorderLevel gt 25 and discontinued eq false").top(1).execute().first());
    }
}

