/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.examples.consumer;

import org.odata4j.consumer.ODataConsumer;
import org.odata4j.consumer.ODataConsumers;
import org.odata4j.consumer.behaviors.OClientBehavior;
import org.odata4j.consumer.behaviors.OClientBehaviors;
import org.odata4j.core.OEntity;
import org.odata4j.core.OEntityKey;
import org.odata4j.core.OProperties;
import org.odata4j.core.OProperty;
import org.odata4j.examples.AbstractExample;

public class AzureTableStorageConsumerExample
extends AbstractExample {
    public static void main(String[] args) {
        AzureTableStorageConsumerExample example = new AzureTableStorageConsumerExample();
        example.run(args);
    }

    private void run(String[] args) {
        String[] azureCreds = args.length > 0 ? args : System.getenv("AZURESTORAGE").split(":");
        String accountKey = azureCreds[0];
        String secretKey = azureCreds[1];
        String url = "http://" + accountKey + ".table.core.windows.net/";
        ODataConsumer c = ODataConsumers.newBuilder((String)url).setClientBehaviors(new OClientBehavior[]{OClientBehaviors.azureTables((String)accountKey, (String)secretKey)}).build();
        AzureTableStorageConsumerExample.report("Create a new temp table to use for the test");
        String tableName = "TempTable" + System.currentTimeMillis();
        c.createEntity("Tables").properties(new OProperty[]{OProperties.string((String)"TableName", (String)tableName)}).execute();
        AzureTableStorageConsumerExample.reportEntities(c, "Tables", 100);
        OEntityKey rowKey1 = OEntityKey.create((Object[])new Object[]{"PartitionKey", "", "RowKey", "1"});
        AzureTableStorageConsumerExample.report("Ensure the new entity does not exist");
        c.deleteEntity(tableName, rowKey1).execute();
        AzureTableStorageConsumerExample.reportEntities(c, tableName, 100);
        AzureTableStorageConsumerExample.report("Create a new entity");
        OEntity newEntity = (OEntity)c.createEntity(tableName).properties((Iterable)rowKey1.asComplexProperties()).properties(new OProperty[]{OProperties.string((String)"foo", (String)"bar")}).execute();
        AzureTableStorageConsumerExample.reportEntities(c, tableName, 100);
        AzureTableStorageConsumerExample.report("Update the new entity");
        c.updateEntity(newEntity).properties(new OProperty[]{OProperties.string((String)"Value", (String)"Sortof Large")}).execute();
        AzureTableStorageConsumerExample.reportEntities(c, tableName, 100);
        AzureTableStorageConsumerExample.report("Merge the new entity");
        c.mergeEntity(tableName, rowKey1).properties(new OProperty[]{OProperties.string((String)"foo", (String)"baz")}).execute();
        AzureTableStorageConsumerExample.reportEntities(c, tableName, 100);
        AzureTableStorageConsumerExample.report("Delete the new entity");
        c.deleteEntity(tableName, rowKey1).execute();
        AzureTableStorageConsumerExample.reportEntities(c, tableName, 100);
        AzureTableStorageConsumerExample.report("Delete the temp table");
        c.deleteEntity("Tables", (Object)tableName).execute();
    }
}

