/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.examples.jersey.consumer;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.PartialRequestBuilder;
import com.sun.jersey.api.client.WebResource;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.core4j.Enumerable;
import org.core4j.xml.XDocument;
import org.core4j.xml.XmlFormat;
import org.odata4j.consumer.AbstractODataClient;
import org.odata4j.consumer.ODataClientRequest;
import org.odata4j.consumer.ODataClientResponse;
import org.odata4j.consumer.ODataConsumer;
import org.odata4j.consumer.behaviors.OClientBehavior;
import org.odata4j.consumer.behaviors.OClientBehaviors;
import org.odata4j.core.OError;
import org.odata4j.core.Throwables;
import org.odata4j.examples.jersey.consumer.JerseyClientFactory;
import org.odata4j.examples.jersey.consumer.JerseyClientResponse;
import org.odata4j.examples.jersey.consumer.JerseyClientUtil;
import org.odata4j.exceptions.ODataProducerException;
import org.odata4j.exceptions.ODataProducerExceptions;
import org.odata4j.format.Entry;
import org.odata4j.format.FormatParserFactory;
import org.odata4j.format.FormatType;
import org.odata4j.format.FormatWriter;
import org.odata4j.format.FormatWriterFactory;
import org.odata4j.format.SingleLink;
import org.odata4j.internal.BOMWorkaroundReader;
import org.odata4j.stax2.XMLEventReader2;
import org.odata4j.stax2.util.StaxUtil;

class ODataJerseyClient
extends AbstractODataClient {
    private final OClientBehavior[] requiredBehaviors = new OClientBehavior[]{OClientBehaviors.methodTunneling((String[])new String[]{"MERGE"})};
    private final OClientBehavior[] behaviors;
    private final Client client;
    private static boolean dontTryRequestHeaders;

    public ODataJerseyClient(FormatType type, JerseyClientFactory clientFactory, OClientBehavior ... behaviors) {
        super(type);
        this.behaviors = (OClientBehavior[])Enumerable.create((Object[])this.requiredBehaviors).concat((Iterable)Enumerable.create((Object[])behaviors)).toArray(OClientBehavior.class);
        this.client = JerseyClientUtil.newClient(clientFactory, behaviors);
    }

    public Reader getFeedReader(ODataClientResponse response) {
        ClientResponse clientResponse = ((JerseyClientResponse)response).getClientResponse();
        if (ODataConsumer.dump.responseBody()) {
            String textEntity = (String)clientResponse.getEntity(String.class);
            this.dumpResponseBody(textEntity, clientResponse.getType());
            return new BOMWorkaroundReader((Reader)new StringReader(textEntity));
        }
        InputStream textEntity = clientResponse.getEntityInputStream();
        try {
            return new BOMWorkaroundReader((Reader)new InputStreamReader(textEntity, "UTF-8"));
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public String requestBody(FormatType formatType, ODataClientRequest request) throws ODataProducerException {
        ODataClientResponse response = this.doRequest(formatType, request, new Response.StatusType[]{ClientResponse.Status.OK});
        String entity = (String)((JerseyClientResponse)response).getClientResponse().getEntity(String.class);
        response.close();
        return entity;
    }

    protected ODataClientResponse doRequest(FormatType reqType, ODataClientRequest request, Response.StatusType ... expectedResponseStatus) throws ODataProducerException {
        Object exception;
        if (this.behaviors != null) {
            for (OClientBehavior behavior : this.behaviors) {
                request = behavior.transform(request);
            }
        }
        WebResource webResource = JerseyClientUtil.resource(this.client, request.getUrl(), this.behaviors);
        for (String qpn : request.getQueryParams().keySet()) {
            webResource = webResource.queryParam(qpn, (String)request.getQueryParams().get(qpn));
        }
        WebResource.Builder b = webResource.getRequestBuilder();
        b = (WebResource.Builder)b.accept(reqType.getAcceptableMediaTypes());
        for (String header : request.getHeaders().keySet()) {
            b.header(header, request.getHeaders().get(header));
        }
        if (!request.getHeaders().containsKey("User-Agent")) {
            b.header("User-Agent", (Object)"odata4j.org");
        }
        if (ODataConsumer.dump.requestHeaders()) {
            this.dumpHeaders(request, webResource, b);
        }
        if (request.getPayload() != null) {
            Class<Entry> payloadClass;
            if (request.getPayload() instanceof Entry) {
                payloadClass = Entry.class;
            } else if (request.getPayload() instanceof SingleLink) {
                payloadClass = SingleLink.class;
            } else {
                throw new IllegalArgumentException("Unsupported payload: " + request.getPayload());
            }
            StringWriter sw = new StringWriter();
            FormatWriter fw = FormatWriterFactory.getFormatWriter(payloadClass, null, (String)this.getFormatType().toString(), null);
            fw.write(null, (Writer)sw, request.getPayload());
            String entity = sw.toString();
            if (ODataConsumer.dump.requestBody()) {
                ODataJerseyClient.dump(entity);
            }
            String contentType = request.getHeaders().containsKey("Content-Type") ? (String)request.getHeaders().get("Content-Type") : fw.getContentType();
            b.entity((Object)entity, contentType);
        }
        ClientResponse response = null;
        try {
            response = (ClientResponse)b.method(request.getMethod(), ClientResponse.class);
        }
        catch (ClientHandlerException e) {
            Throwables.propagate((Throwable)e);
        }
        if (ODataConsumer.dump.responseHeaders()) {
            this.dumpHeaders(response);
        }
        ClientResponse.Status status = response.getClientResponseStatus();
        for (Response.StatusType expStatus : expectedResponseStatus) {
            if (expStatus.getStatusCode() != status.getStatusCode()) continue;
            return new JerseyClientResponse(response);
        }
        String textEntity = (String)response.getEntity(String.class);
        try {
            MediaType contentType = response.getType();
            OError error = (OError)FormatParserFactory.getParser(OError.class, (MediaType)contentType, null).parse((Reader)new StringReader(textEntity));
            exception = ODataProducerExceptions.create((Response.StatusType)status, (OError)error);
        }
        catch (RuntimeException e) {
            exception = new RuntimeException(String.format("Expected status %s, found %s. Server response:", Enumerable.create((Object[])expectedResponseStatus).join(" or "), status) + "\n" + textEntity, e);
        }
        throw exception;
    }

    protected XMLEventReader2 toXml(ODataClientResponse response) {
        ClientResponse clientResponse = ((JerseyClientResponse)response).getClientResponse();
        if (ODataConsumer.dump.responseBody()) {
            String textEntity = (String)clientResponse.getEntity(String.class);
            this.dumpResponseBody(textEntity, clientResponse.getType());
            return StaxUtil.newXMLEventReader((Reader)new BOMWorkaroundReader((Reader)new StringReader(textEntity)));
        }
        InputStream textEntity = clientResponse.getEntityInputStream();
        try {
            return StaxUtil.newXMLEventReader((Reader)new BOMWorkaroundReader((Reader)new InputStreamReader(textEntity, "UTF-8")));
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private void dumpResponseBody(String textEntity, MediaType type) {
        String logXml = textEntity;
        if (type.toString().contains("xml") || logXml != null && logXml.startsWith("<feed")) {
            try {
                logXml = XDocument.parse((String)logXml).toString(XmlFormat.INDENTED);
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        ODataJerseyClient.dump(logXml);
    }

    private void dumpHeaders(ClientResponse response) {
        ODataJerseyClient.dump("Status: " + response.getStatus());
        this.dump(response.getHeaders());
    }

    private MultivaluedMap<String, Object> getRequestHeaders(WebResource.Builder b) {
        if (dontTryRequestHeaders) {
            return null;
        }
        try {
            Field f = PartialRequestBuilder.class.getDeclaredField("metadata");
            f.setAccessible(true);
            return (MultivaluedMap)f.get(b);
        }
        catch (Exception e) {
            dontTryRequestHeaders = true;
            return null;
        }
    }

    private void dumpHeaders(ODataClientRequest request, WebResource webResource, WebResource.Builder b) {
        ODataJerseyClient.dump(request.getMethod() + " " + webResource);
        this.dump(this.getRequestHeaders(b));
    }

    private void dump(MultivaluedMap headers) {
        if (headers == null) {
            return;
        }
        for (Object header : headers.keySet()) {
            ODataJerseyClient.dump(header + ": " + headers.getFirst(header));
        }
    }

    private static void dump(String message) {
        System.out.println(message);
    }
}

