/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.blueprint.parser.xb;

// $Id: TArgument.java 91345 2009-07-16 14:16:10Z thomas.diesler@jboss.com $

import java.math.BigInteger;

import javax.xml.bind.annotation.XmlType;

import org.jboss.osgi.blueprint.BlueprintContext;

/**
 *  An argument used to create an object defined by a <bean>
 *  component.  The <argument> elements are the arguments for the
 *  bean class constructor or passed to the bean factory method.
 *  
 *  The type, if specified, is used to disambiguate the constructor
 *  or method signature.  Arguments may also be matched up with
 *  arguments by explicitly specifying the index position.  If the
 *  index is used, then all <argument> elements for the bean must
 *  also specify the index.
 *  
 *  The value and ref attributes are convenience shortcuts to make
 *  the <argument> tag easier to code.  A fuller set of injected
 *  values and types can be specified using one of the "value"
 *  type elements.
 *  
 *  <xsd:complexType name="Targument">
 *   <xsd:sequence>
 *    <xsd:element name="description" type="Tdescription" minOccurs="0" />
 *    <xsd:group ref="Gvalue" minOccurs="0" />
 *   </xsd:sequence>
 *   <xsd:attribute name="index" type="xsd:nonNegativeInteger" />
 *   <xsd:attribute name="type" type="Ttype" />
 *   <xsd:attribute name="ref" type="Tidref" />
 *   <xsd:attribute name="value" type="TstringValue" />
 * </xsd:complexType>
 * 
 * @author thomas.diesler@jboss.com
 * @since 13-May-2009
 */
@XmlType(name = "Targument", namespace = BlueprintContext.XMLNS_BLUEPRINT, propOrder = { "description", "valueElement" })
public class TArgument extends GValue
{
   protected String description;
   protected BigInteger index;
   protected String type;
   protected String ref;
   protected String value;

   public String getDescription()
   {
      return description;
   }

   public void setDescription(String description)
   {
      this.description = description;
   }

   public BigInteger getIndex()
   {
      return index;
   }

   public void setIndex(BigInteger index)
   {
      this.index = index;
   }

   public String getType()
   {
      return type;
   }

   public void setType(String type)
   {
      this.type = type;
   }

   public String getRef()
   {
      return ref;
   }

   public void setRef(String ref)
   {
      this.ref = ref;
   }

   public String getValue()
   {
      return value;
   }

   public void setValue(String value)
   {
      this.value = value;
   }
}
