/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.blueprint.parser.xb;

// $Id: TBean.java 91345 2009-07-16 14:16:10Z thomas.diesler@jboss.com $

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;

import org.jboss.osgi.blueprint.BlueprintContext;

/**
 * The type definition for a <bean> component. 
 * 
 * The <bean> attributes provide the characteristics for how to create a bean instance. 
 * Constructor arguments and injected properties are specified via child <argument> and <property> elements.
 * 
 * <xsd:complexType name="Tbean"> 
 *  <xsd:complexContent> 
 *   <xsd:extension base="Tcomponent"> 
 *    <xsd:group ref="GbeanElements" /> 
 *    <xsd:attribute name="class" type="Tclass" />
 *    <xsd:attribute name="init-method" type="Tmethod" /> 
 *    <xsd:attribute name="destroy-method" type="Tmethod" /> 
 *    <xsd:attribute name="factory-method" type="Tmethod" />
 *    <xsd:attribute name="factory-ref" type="Tidref" /> 
 *    <xsd:attribute name="scope" type="Tscope" /> 
 *    <xsd:anyAttribute namespace="##other" processContents="strict" />
 *   </xsd:extension> 
 *  </xsd:complexContent> 
 * </xsd:complexType>
 * 
 *  <xsd:complexType name="Tcomponent" abstract="true">
 *   <xsd:attribute name="id" type="xsd:ID" />
 *   <xsd:attribute name="activation" type="Tactivation">
 *   <xsd:attribute name="depends-on" type="TdependsOn">
 * </xsd:complexType>
 *
 * <xsd:group name="GbeanElements"> 
 *  <xsd:sequence> 
 *   <xsd:element name="description" type="Tdescription" minOccurs="0" /> 
 *   <xsd:choice minOccurs="0" maxOccurs="unbounded">
 *    <xsd:element name="argument" type="Targument" /> 
 *    <xsd:element name="property" type="Tproperty" /> 
 *    <xsd:any namespace="##other" processContents="strict" />
 *   </xsd:choice> 
 *  </xsd:sequence> 
 * </xsd:group>
 * 
 * @author thomas.diesler@jboss.com
 * @since 13-May-2009
 */
@XmlType(name = "Tbean", namespace = BlueprintContext.XMLNS_BLUEPRINT, propOrder = { "description", "beanElements" })
public class TBean extends TComponent
{
   protected String description;
   protected List<Object> beanElements;
   protected String className;
   protected String initMethod;
   protected String destroyMethod;
   protected String factoryMethod;
   protected String factoryRef;
   protected String scope;
   private Map<QName, String> otherAttributes = new HashMap<QName, String>();

   public String getDescription()
   {
      return description;
   }

   public void setDescription(String value)
   {
      this.description = value;
   }

   @XmlElements( { 
      @XmlElement(name = "property", namespace = BlueprintContext.XMLNS_BLUEPRINT, type = TProperty.class),
      @XmlElement(name = "argument", namespace = BlueprintContext.XMLNS_BLUEPRINT, type = TArgument.class) })
   public List<Object> getBeanElements()
   {
      if (beanElements == null)
         beanElements = new ArrayList<Object>();
      
      return beanElements;
   }

   public void setBeanElements(List<Object> beanElements)
   {
      this.beanElements = beanElements;
   }

   public List<TProperty> getProperties()
   {
      List<TProperty> props = new ArrayList<TProperty>();
      for (Object obj : getBeanElements())
      {
         if (obj instanceof TProperty)
            props.add((TProperty)obj);
      }
      return props;
   }
   
   @XmlAttribute(name = "class")
   public String getClassName()
   {
      return className;
   }

   public void setClassName(String value)
   {
      this.className = value;
   }

   public String getInitMethod()
   {
      return initMethod;
   }

   public void setInitMethod(String value)
   {
      this.initMethod = value;
   }

   public String getDestroyMethod()
   {
      return destroyMethod;
   }

   public void setDestroyMethod(String value)
   {
      this.destroyMethod = value;
   }

   public String getFactoryMethod()
   {
      return factoryMethod;
   }

   public void setFactoryMethod(String value)
   {
      this.factoryMethod = value;
   }

   public String getFactoryRef()
   {
      return factoryRef;
   }

   public void setFactoryRef(String value)
   {
      this.factoryRef = value;
   }

   public String getScope()
   {
      return scope;
   }

   public void setScope(String value)
   {
      this.scope = value;
   }

   public Map<QName, String> getOtherAttributes()
   {
      return otherAttributes;
   }
}
