/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.blueprint.parser.xb;

// $Id: TServiceProperties.java 91345 2009-07-16 14:16:10Z thomas.diesler@jboss.com $

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlType;

import org.jboss.osgi.blueprint.BlueprintContext;


/**
 *  TserviceProperty is used for <service-properties> elements.
 *  The syntax is similar to what is defined for <map>, but keys must be
 *  string values and there are no type defaults that can be specified.
 *  created from the entry elements, which require a key/value pair.
 *  
 * 
 * <xsd:complexType name="TserviceProperties">
 *   <xsd:sequence>
 *     <xsd:element name="entry" type="TservicePropertyEntry"  minOccurs="0" maxOccurs="unbounded" />
 *     <xsd:any namespace="##other" processContents="strict"  minOccurs="0" maxOccurs="unbounded" />
 *   </xsd:sequence>
 * </xsd:complexType>
 * 
 * @author thomas.diesler@jboss.com
 * @since 13-May-2009
 */
@XmlType(name = "TserviceProperties", namespace = BlueprintContext.XMLNS_BLUEPRINT)
public class TServiceProperties {

    protected List<TServicePropertyEntry> entry;

    /**
     * Gets the value of the entry property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the entry property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getEntry().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TServicePropertyEntry }
     * 
     * 
     */
    public List<TServicePropertyEntry> getEntry() {
        if (entry == null) {
            entry = new ArrayList<TServicePropertyEntry>();
        }
        return this.entry;
    }

}
