/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.blueprint.reflect;

// $Id: ServiceReferenceMetadataImpl.java 91294 2009-07-15 13:41:27Z thomas.diesler@jboss.com $

import java.util.Collection;

import org.jboss.osgi.blueprint.BlueprintContext;
import org.jboss.osgi.blueprint.parser.xb.TAvailability;
import org.jboss.osgi.blueprint.parser.xb.TServiceReference;
import org.jboss.osgi.spi.NotImplementedException;
import org.osgi.service.blueprint.reflect.ReferenceListener;
import org.osgi.service.blueprint.reflect.ServiceReferenceMetadata;

/**
 * Metadata representing a service to be exported by a module context.
 * 
 * @author thomas.diesler@jboss.com
 * @since 13-May-2009
 */
public abstract class ServiceReferenceMetadataImpl extends ComponentMetadataImpl implements ServiceReferenceMetadata
{
   private TServiceReference tService;
   
   public ServiceReferenceMetadataImpl(BlueprintContext context, BlueprintMetadata blueprint, TServiceReference tService)
   {
      super(context, blueprint, tService);
      this.tService = tService;
   }

   public int getAvailability()
   {
      int availability = AVAILABILITY_OPTIONAL;
      
      if (tService.getAvailability() == TAvailability.mandatory)
         availability = AVAILABILITY_MANDATORY;
      
      return availability;
   }

   public String getComponentName()
   {
      return tService.getComponentName();
   }

   public String getFilter()
   {
      return tService.getFilter();
   }

   public String getInterface()
   {
      return tService.getInterface();
   }

   public Collection<ReferenceListener> getReferenceListeners()
   {
      throw new NotImplementedException();
   }

   public String toString()
   {
      return "ServiceReference[id=" + getId() + "]";
   }
}
