/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.blueprint.extender;

//$Id: BlueprintActivator.java 91000 2009-07-09 13:19:56Z thomas.diesler@jboss.com $

import org.jboss.osgi.blueprint.BlueprintService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleListener;

/**
 * The Blueprint activator registeres the {@link BlueprintExtender} 
 * as {@link BundleListener}
 * 
 * @author thomas.diesler@jboss.com
 * @since 13-May-2009
 */
public class BlueprintActivator implements BundleActivator
{
   private BlueprintExtender extender;
   
   public void start(BundleContext context) throws Exception
   {
      // Register the marker service
      BlueprintService service = new BlueprintService(){};
      context.registerService(BlueprintService.class.getName(), service, null);
      
      extender = new BlueprintExtender(new BlueprintContextImpl(context));
      context.addBundleListener(extender);
   }

   public void stop(BundleContext context) throws Exception
   {
      if (extender != null)
      {
         context.removeBundleListener(extender);
         extender.stop();
         extender = null;
      }
   }
}