/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.blueprint.parser;

//$Id: SchemaResolverParser.java 90806 2009-07-03 08:27:52Z thomas.diesler@jboss.com $

import java.net.URL;

import org.jboss.osgi.blueprint.BlueprintContext;
import org.jboss.osgi.blueprint.BlueprintException;
import org.jboss.osgi.blueprint.parser.xb.TBlueprint;
import org.jboss.util.xml.JBossEntityResolver;
import org.jboss.xb.binding.JBossXBException;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.jboss.xb.binding.sunday.unmarshalling.DefaultSchemaResolver;

/**
 * The Blueprint descriptor parser.
 * 
 * @author thomas.diesler@jboss.com
 * @since 13-May-2009
 */
public class SchemaResolverParser implements JBossXBParser
{
   public SchemaResolverParser(BlueprintContext context)
   {
   }

   /*
    * Parse a blueprint descriptor
    */
   public TBlueprint parse(URL xmlURL)
   {
      if (xmlURL == null)
         throw new IllegalArgumentException("Cannot parse null descriptor URL");

      ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
      try
      {
         ClassLoader bundleCL = getClass().getClassLoader();
         Thread.currentThread().setContextClassLoader(bundleCL);

         Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
         unmarshaller.setSchemaValidation(true);
         unmarshaller.setNamespaceAware(true);
         unmarshaller.setValidation(true);
         
         // This is EntityResolver that SAX parser (xerces) will use to resolve XSD location for the XML being parsed
         // Here we map schema location specified in the XSD file to the local schema location,
         // which is a path relative to the resources directory visible in the classpath.
         JBossEntityResolver xmlResolver = new JBossEntityResolver();
         xmlResolver.registerLocalEntity("http://www.osgi.org/xmlns/blueprint/v1.0.0/blueprint.xsd", "schema/blueprint.xsd");
         unmarshaller.setEntityResolver(xmlResolver);
         
         // This is to resolve namespace to class mapping and build the SchemaBinding from the class
         DefaultSchemaResolver schemaBindingResolver = new DefaultSchemaResolver();
         schemaBindingResolver.addClassBinding(BlueprintContext.XMLNS_BLUEPRINT, TBlueprint.class);
         
         TBlueprint tBlueprint = (TBlueprint)unmarshaller.unmarshal(xmlURL.toExternalForm(), schemaBindingResolver);

         return tBlueprint;
      }
      catch (JBossXBException ex)
      {
         throw new BlueprintException("Cannot parse blueprint descriptor: " + xmlURL, ex);
      }
      finally
      {
         Thread.currentThread().setContextClassLoader(ctxLoader);
      }
   }
}