/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.blueprint.parser.xb;

//$Id: TComponent.java 91345 2009-07-16 14:16:10Z thomas.diesler@jboss.com $

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;

import org.jboss.osgi.blueprint.BlueprintContext;

/**
 * The Tcomponent type is the base type for top-level Blueprint components.  
 * The <bean> <reference>, <service>, and <reference-list> elements are all derived from
 * the Tcomponent type.  This type defines an id attribute that is used create references 
 * between different components.
 * 
 * Component elements can also be inlined within other component definitions.  
 * The id attribute is not valid when inlined.
 * 
 * <xsd:complexType name="Tcomponent" abstract="true">
 *   <xsd:attribute name="id" type="xsd:ID" />
 *   <xsd:attribute name="activation" type="Tactivation">
 *   <xsd:attribute name="depends-on" type="TdependsOn">
 * </xsd:complexType>
 * 
 * <xsd:simpleType name="Tactivation">
 *   <xsd:restriction base="xsd:NMTOKEN">
 *     <xsd:enumeration value="eager" />
 *     <xsd:enumeration value="lazy" />
 *   </xsd:restriction>
 * </xsd:simpleType>
 * 
 * <xsd:simpleType name="TdependsOn">
 *   <xsd:restriction>
 *     <xsd:simpleType>
 *       <xsd:list itemType="Tidref" />
 *     </xsd:simpleType>
 *     <xsd:minLength value="1" />
 *   </xsd:restriction>
 * </xsd:simpleType>
 * 
 * @author thomas.diesler@jboss.com
 * @since 13-May-2009
 */
@XmlType(name = "Tcomponent", namespace = BlueprintContext.XMLNS_BLUEPRINT)
public abstract class TComponent
{
   protected String id;
   // How can I map an attribute to List of String
   // http://www.jboss.org/index.html?module=bb&op=viewtopic&p=4244086#4244086
   protected String dependsOn;
   protected TActivation activation;

   @XmlAttribute(name = "id")
   public String getId()
   {
      return id;
   }

   public void setId(String value)
   {
      this.id = value;
   }

   @XmlAttribute
   public String getDependsOn()
   {
      return dependsOn;
   }

   public void setDependsOn(String dependsOn)
   {
      this.dependsOn = dependsOn;
   }

   @XmlAttribute
   public TActivation getActivation()
   {
      return activation;
   }

   public void setActivation(TActivation activation)
   {
      this.activation = activation;
   }
}
