/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.blueprint.parser.xb;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;

import org.jboss.osgi.blueprint.BlueprintContext;

//$Id: TRef.java 91348 2009-07-16 15:54:22Z thomas.diesler@jboss.com $

/**
 * Tref is the type used for <ref> elements.  
 * This specifies a required component id for the reference component.
 * 
 * <xsd:complexType name="Tref">
 *   <xsd:attribute name="component-id" type="Tidref" use="required" />
 * </xsd:complexType>
 * 
 * @author thomas.diesler@jboss.com
 * @since 13-May-2009
 */
@XmlType(name = "Tref", namespace = BlueprintContext.XMLNS_BLUEPRINT)
public class TRef
{
   protected String componentId;

   @XmlAttribute(required = true)
   public String getComponentId()
   {
      return componentId;
   }

   public void setComponentId(String value)
   {
      this.componentId = value;
   }

}
