/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.blueprint.parser.xb;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlType;

import org.jboss.osgi.blueprint.BlueprintContext;

//$Id: TReferenceList.java 91345 2009-07-16 14:16:10Z thomas.diesler@jboss.com $

/**
 * The Treference-list builds in the characteristics of the 
 * TserviceReference type to define characteristics of the <reference-list>.
 * 
 * This adds in the characteristics that only apply to collections of references (e.g., member-type).
 * 
 * <xsd:complexType name="Treference-list">
 *   <xsd:complexContent>
 *     <xsd:extension base="TserviceReference">
 *       <xsd:sequence>
 *         <xsd:any namespace="##other" minOccurs="0" maxOccurs="unbounded" processContents="strict" />
 *       </xsd:sequence>
 *       <xsd:attribute name="member-type" type="Tservice-use" default="service-object">
 *     </xsd:extension>
 *   </xsd:complexContent>
 * </xsd:complexType>
 * 
 * @author thomas.diesler@jboss.com
 * @since 13-May-2009
 */
//[JBXB-210] Property order cannot be defined on super type
//https://jira.jboss.org/jira/browse/JBXB-210
@XmlType(name = "Treference-list", namespace = BlueprintContext.XMLNS_BLUEPRINT, propOrder = { "description" })
public class TReferenceList extends TServiceReference
{
   protected TServiceUse memberType;
   protected List<Object> any;

   public TServiceUse getMemberType()
   {
      return memberType;
   }

   public void setMemberType(TServiceUse value)
   {
      this.memberType = value;
   }

   public List<Object> getAny()
   {
      if (any == null)
         any = new ArrayList<Object>();

      return this.any;
   }
}
