/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.blueprint.parser.xb;

// $Id: TRegistrationListener.java 91345 2009-07-16 14:16:10Z thomas.diesler@jboss.com $

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;

import org.jboss.osgi.blueprint.BlueprintContext;

/**
 * A registration listener definition.  The target registration listener
 * can be either a <ref> to a <bean> or <service> component, or an inline
 * <bean> or <service> component definition.  The registration-method and
 * unregistration-method attributes define the methods that will be called
 * for the respective events.
 * 
 * For the very common case of using a <ref> to a listener component, the
 * ref attribute may also be used as a shortcut.
 * 
 * <xsd:complexType name="TregistrationListener">
 *   <xsd:sequence>
 *     <xsd:group ref="GtargetComponent" minOccurs="0" />
 *   </xsd:sequence>
 *   <xsd:attribute name="ref" type="Tidref" />
 *   <xsd:attribute name="registration-method" type="Tmethod" />
 *   <xsd:attribute name="unregistration-method" type="Tmethod" />
 * </xsd:complexType>
 * 
 */

//[JBXB-210] Property order cannot be defined on super type
//https://jira.jboss.org/jira/browse/JBXB-210
//@XmlType(name = "TregistrationListener", namespace = BlueprintContext.XMLNS_BLUEPRINT)

@XmlType(name = "TregistrationListener", namespace = BlueprintContext.XMLNS_BLUEPRINT, propOrder = { "bean", "reference", "refElement" })
public class TRegistrationListener extends GTargetComponent
{
   protected String ref;
   protected String registrationMethod;
   protected String unregistrationMethod;

   @XmlAttribute(name = "registration-method")
   public String getRegistrationMethod()
   {
      return registrationMethod;
   }

   public void setRegistrationMethod(String value)
   {
      this.registrationMethod = value;
   }

   @XmlAttribute(name = "unregistration-method")
   public String getUnregistrationMethod()
   {
      return unregistrationMethod;
   }

   public void setUnregistrationMethod(String value)
   {
      this.unregistrationMethod = value;
   }

   @XmlAttribute
   public String getRef()
   {
      return ref;
   }

   public void setRef(String value)
   {
      this.ref = value;
   }

}
