/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.blueprint.reflect;

// $Id: ComponentMetadataImpl.java 91345 2009-07-16 14:16:10Z thomas.diesler@jboss.com $

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.jboss.osgi.blueprint.BlueprintContext;
import org.jboss.osgi.blueprint.parser.xb.TActivation;
import org.jboss.osgi.blueprint.parser.xb.TComponent;
import org.osgi.service.blueprint.reflect.ComponentMetadata;

/**
 * Base class for all components.
 * 
 * @author thomas.diesler@jboss.com
 * @since 13-May-2009
 */
public class ComponentMetadataImpl extends MetadataImpl implements ComponentMetadata
{
   protected TComponent tComp;

   public ComponentMetadataImpl(BlueprintContext context, BlueprintMetadata blueprint, TComponent tComp)
   {
      super(context, blueprint);
      this.tComp = tComp;
   }

   public List<String> getDependsOn()
   {
      List<String> dependsOn = new ArrayList<String>();
      if (tComp.getDependsOn() != null)
         dependsOn = Arrays.asList(tComp.getDependsOn().split("/s"));
      
      return dependsOn;
   }

   public String getId()
   {
      return tComp.getId();
   }

   public String getKey()
   {
      String key = tComp.getId();
      if (key == null)
         throw new IllegalStateException("Cannot obtain key for componenet: " + tComp);
      
      return key;
   }
   
   public int getActivation()
   {
      int activationCode = blueprint.getDefaultActivation();
      TActivation activation = tComp.getActivation();
      if (activation != null)
      {
         if (activation == TActivation.lazy)
            activationCode = ComponentMetadata.ACTIVATION_LAZY;
         else if (activation == TActivation.eager)
            activationCode = ComponentMetadata.ACTIVATION_EAGER;
         else
            throw new IllegalStateException("Unsuported activation code: " + activation);
      }
      return activationCode;
   }
}
