/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.blueprint.container;

//$Id: ReferenceManager.java 90690 2009-06-30 12:09:27Z thomas.diesler@jboss.com $

import org.jboss.osgi.blueprint.BlueprintContext;
import org.jboss.osgi.blueprint.reflect.ReferenceMetadataImpl;
import org.osgi.service.blueprint.container.BlueprintContainer;
import org.osgi.service.blueprint.reflect.ReferenceMetadata;
import org.osgi.util.tracker.ServiceTracker;

/**
 * Reference managers track a service in the OSGi service registry.
 * When activated, they provide a ServiceReference object or a proxy
 * to a service object. 
 * 
 * A reference is satisfied when its selection matches a service in the
 * registry.
 *  
 * @author thomas.diesler@jboss.com
 * @since 17-Jun-2009
 */
public class ReferenceManager extends AbstractManager
{
   private ReferenceMetadataImpl refMetadata;
   private ServiceTracker tracker;

   public ReferenceManager(BlueprintContext context, BlueprintContainer container, ReferenceMetadata compMetadata)
   {
      super(context, container, compMetadata);
      this.refMetadata = (ReferenceMetadataImpl)compMetadata;
   }

   public ServiceTracker getServiceTracker()
   {
      if (tracker == null)
      {
         String intfName = refMetadata.getInterface();
         tracker = new ServiceTracker(context.getBundleContext(), intfName, null);
         tracker.open();
      }
      return tracker;
   }

   public Object getService()
   {
      return getServiceTracker().getService();
   }
}