/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.blueprint.extender;

//$Id: BlueprintInterceptor.java 95822 2009-10-30 11:09:19Z thomas.diesler@jboss.com $

import org.jboss.osgi.blueprint.BlueprintContext;
import org.jboss.osgi.deployment.interceptor.AbstractLifecycleInterceptor;
import org.jboss.osgi.deployment.interceptor.InvocationContext;
import org.jboss.osgi.deployment.interceptor.LifecycleInterceptor;
import org.jboss.osgi.deployment.interceptor.LifecycleInterceptorException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * The Blueprint interceptor
 * 
 * @author thomas.diesler@jboss.com
 * @since 20-Oct-2009
 */
public class BlueprintInterceptor extends AbstractLifecycleInterceptor implements LifecycleInterceptor
{
   // Provide logging
   private Logger log = LoggerFactory.getLogger(BlueprintInterceptor.class);
   
   private BlueprintProcessor processor;
   
   public BlueprintInterceptor(BlueprintProcessor processor)
   {
      this.processor = processor;
   }

   public void start()
   {
      BlueprintContext bpContext = processor.getBlueprintContext();
      BundleContext context = bpContext.getBundleContext();
      context.registerService(LifecycleInterceptor.class.getName(), this, null);
   }
   
   public void stop()
   {
      processor.stopAllContainers();
   }

   public void invoke(int state, InvocationContext context) throws LifecycleInterceptorException
   {
      Bundle bundle = context.getBundle();
      if (state == Bundle.STARTING)
      {
         log.debug("Create blueprint container");
         processor.createContainer(bundle);
      }
      else if (state == Bundle.STOPPING)
      {
         log.debug("Stop blueprint container");
         processor.stopContainer(bundle);
      }
   }
}