/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.blueprint.parser.xb;

// $Id: TService.java 91345 2009-07-16 14:16:10Z thomas.diesler@jboss.com $

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;

import org.jboss.osgi.blueprint.BlueprintContext;

/**
 * Tservice is the type for services exported by this blueprint bundle.
 * Services are sourced by either a <ref> to a <bean> component or an
 * <inline> bean component.
 * 
 * <xsd:complexType name="Tservice">
 *   <xsd:complexContent>
 *     <xsd:extension base="Tcomponent">
 *       <xsd:sequence>
 *         <xsd:group ref="GserviceElements" />
 *       </xsd:sequence>
 *       <xsd:attribute name="interface" type="Tclass">
 *       <xsd:attribute name="ref" type="Tidref">
 *       <xsd:attribute name="auto-export" type="TautoExportModes"
 *       <xsd:attribute name="ranking" type="xsd:int" default="0">
 *       <xsd:anyAttribute namespace="##other" processContents="strict" />
 *     </xsd:extension>
 *   </xsd:complexContent>
 * </xsd:complexType>
 * 
 *  <xsd:complexType name="Tcomponent" abstract="true">
 *   <xsd:attribute name="id" type="xsd:ID" />
 *   <xsd:attribute name="activation" type="Tactivation">
 *   <xsd:attribute name="depends-on" type="TdependsOn">
 * </xsd:complexType>
 *
 * <xsd:group name="GserviceElements">
 *   <xsd:sequence>
 *     <xsd:group ref="GbaseServiceElements" />
 *     <xsd:group ref="GtargetComponent" minOccurs="0">
 *   </xsd:sequence>
 * </xsd:group>
 * 
 * <xsd:group name="GbaseServiceElements">
 *   <xsd:sequence>
 *     <xsd:element name="description" type="Tdescription"  minOccurs="0" />
 *     <xsd:element name="interfaces" type="Tinterfaces" minOccurs="0">
 *     <xsd:element name="service-properties" type="TserviceProperties" minOccurs="0">
 *     <xsd:element name="registration-listener" type="TregistrationListener" minOccurs="0" maxOccurs="unbounded">
 *   </xsd:sequence>
 * </xsd:group>
 * 
 * @author thomas.diesler@jboss.com
 * @since 13-May-2009
 */
@XmlType(name = "Tservice", namespace = BlueprintContext.XMLNS_BLUEPRINT, 
      propOrder = { "description", "interfaces", "serviceProperties", "registrationListeners", "bean", "ref" })
public class TService extends GTargetComponent
{
   protected String description;
   protected TInterfaces interfaces;
   protected TServiceProperties serviceProperties;
   protected List<TRegistrationListener> registrationListener;
   protected String ref;
   protected TAutoExportModes autoExport;
   protected int ranking;
   private Map<QName, String> otherAttributes = new HashMap<QName, String>();

   public String getDescription()
   {
      return description;
   }

   public void setDescription(String value)
   {
      this.description = value;
   }

   @XmlAttribute(name = "interface")
   public String getInterface()
   {
      List<String> interfaceNames = getInterfaces().getValues();
      return interfaceNames.size() > 0 ? interfaceNames.get(0) : null;
   }

   public void setInterface(String interf)
   {
      getInterfaces().getValues().add(interf);
   }

   @XmlElement(name = "interfaces")
   public TInterfaces getInterfaces()
   {
      if (interfaces == null)
         interfaces = new TInterfaces();

      return interfaces;
   }

   public void setInterfaces(TInterfaces interfaces)
   {
      this.interfaces = interfaces;
   }

   public TServiceProperties getServiceProperties()
   {
      if (serviceProperties == null)
         serviceProperties = new TServiceProperties();

      return serviceProperties;
   }

   public void setServiceProperties(TServiceProperties serviceProperties)
   {
      this.serviceProperties = serviceProperties;
   }

   @XmlElement(name = "registration-listener")
   public List<TRegistrationListener> getRegistrationListeners()
   {
      if (registrationListener == null)
         registrationListener = new ArrayList<TRegistrationListener>();

      return registrationListener;
   }

   public void setRegistrationListeners(List<TRegistrationListener> registrationListener)
   {
      this.registrationListener = registrationListener;
   }

   @XmlAttribute
   public String getRef()
   {
      return ref;
   }

   public void setRef(String ref)
   {
      this.ref = ref;
   }

   public TAutoExportModes getAutoExport()
   {
      if (autoExport == null)
         autoExport = TAutoExportModes.disabled;

      return autoExport;
   }

   public void setAutoExport(TAutoExportModes value)
   {
      this.autoExport = value;
   }

   public int getRanking()
   {
      return ranking;
   }

   public void setRanking(int value)
   {
      this.ranking = value;
   }

   public Map<QName, String> getOtherAttributes()
   {
      return otherAttributes;
   }
}
