/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.blueprint.parser.xb;

// $Id: TServiceReference.java 91345 2009-07-16 14:16:10Z thomas.diesler@jboss.com $

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;

import org.jboss.osgi.blueprint.BlueprintContext;

/**
 * TserviceReference is the base element type used for <reference>, <ref-set>, and <ref-list> elements. 
 * This type defines all of the characteristics common to both sorts of references.
 * 
 * <xsd:complexType name="TserviceReference">
 *   <xsd:complexContent>
 *     <xsd:extension base="Tcomponent">
 *       <xsd:sequence>
 *         <xsd:group ref="GserviceReferenceElements" />
 *       </xsd:sequence>
 *       <xsd:attribute name="interface" type="Tclass">
 *       <xsd:attribute name="filter" type="xsd:normalizedString">
 *       <xsd:attribute name="component-name" type="Tidref">
 *       <xsd:attribute name="availability" type="Tavailability">
 *       <xsd:anyAttribute namespace="##other" processContents="strict" />
 *     </xsd:extension>
 *   </xsd:complexContent>
 * </xsd:complexType>
 * 
 * <xsd:group name="GserviceReferenceElements">
 *   <xsd:sequence>
 *     <xsd:element name="description" type="Tdescription" minOccurs="0" />
 *     <xsd:element name="reference-listener" type="TreferenceListener" minOccurs="0" maxOccurs="unbounded">
 *   </xsd:sequence>
 * </xsd:group>
 * 
 * @author thomas.diesler@jboss.com
 * @since 13-May-2009
 */
@XmlType(name = "TserviceReference", namespace = BlueprintContext.XMLNS_BLUEPRINT, propOrder = { "description", "referenceListeners" })
public class TServiceReference extends TComponent
{
   protected String description;
   protected List<TReferenceListener> listener;
   private String interfaceName;
   protected String filter;
   protected String componentName;
   protected TAvailability availability;
   
   private Map<QName, String> otherAttributes = new HashMap<QName, String>();

   public String getDescription()
   {
      return description;
   }

   public void setDescription(String value)
   {
      this.description = value;
   }

   @XmlElement(name = "reference-listener")
   public List<TReferenceListener> getReferenceListeners()
   {
      if (listener == null)
         listener = new ArrayList<TReferenceListener>();

      return this.listener;
   }

   public void setReferenceListeners(List<TReferenceListener> listener)
   {
      this.listener = listener;
   }

   public String getFilter()
   {
      return filter;
   }

   public void setFilter(String value)
   {
      this.filter = value;
   }

   public String getComponentName()
   {
      return componentName;
   }

   public void setComponentName(String value)
   {
      this.componentName = value;
   }

   @XmlAttribute
   public TAvailability getAvailability()
   {
      if (availability == null)
         availability = TAvailability.optional;

      return availability;
   }

   public void setAvailability(TAvailability value)
   {
      this.availability = value;
   }

   @XmlAttribute
   public String getInterface()
   {
      return interfaceName;
   }

   public void setInterface(String interfaceName)
   {
      this.interfaceName = interfaceName;
   }

   public Map<QName, String> getOtherAttributes()
   {
      return otherAttributes;
   }

}
