/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.blueprint.reflect;

// $Id: BeanPropertyImpl.java 90690 2009-06-30 12:09:27Z thomas.diesler@jboss.com $

import org.jboss.osgi.blueprint.BlueprintContext;
import org.jboss.osgi.blueprint.parser.xb.TProperty;
import org.osgi.service.blueprint.reflect.BeanProperty;
import org.osgi.service.blueprint.reflect.Metadata;

/**
 * Metadata describing a property to be injected. 
 * 
 * @author thomas.diesler@jboss.com
 * @since 13-May-2009
 */
public class BeanPropertyImpl extends MetadataImpl implements BeanProperty
{
   private TProperty tProperty;
   private Metadata value;

   public BeanPropertyImpl(BlueprintContext context, BlueprintMetadata blueprint, TProperty tProperty)
   {
      super(context, blueprint);
      this.tProperty = tProperty;
   }

   public String getName()
   {
      return tProperty.getName();
   }

   public Metadata getValue()
   {
      if (value == null)
      {
         String ref = tProperty.getRef();
         if (ref != null)
         {
            value = blueprint.getComponent(ref);
         }
         
         if (value == null)
            throw new IllegalStateException("Cannot obtain value for property: " + getName());
      }
      return value;
   }
}
