/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.blueprint.reflect;

// $Id: ComponentFactory.java 90690 2009-06-30 12:09:27Z thomas.diesler@jboss.com $

import org.jboss.osgi.blueprint.BlueprintContext;
import org.jboss.osgi.blueprint.parser.xb.TBean;
import org.jboss.osgi.blueprint.parser.xb.TComponent;
import org.jboss.osgi.blueprint.parser.xb.TReference;
import org.jboss.osgi.blueprint.parser.xb.TService;
import org.osgi.service.blueprint.reflect.ComponentMetadata;

/**
 * A factory for component metadata.
 * 
 * @author thomas.diesler@jboss.com
 * @since 13-May-2009
 */
public class ComponentFactory
{
   private BlueprintContext context;
   private BlueprintMetadata blueprint;
   private int anonymousId;

   public ComponentFactory(BlueprintContext context, BlueprintMetadata blueprint)
   {
      this.context = context;
      this.blueprint = blueprint;
   }

   public ComponentMetadata createComponent(TComponent tComp)
   {
      return createComponent(null, tComp, false);
   }
   
   public ComponentMetadata createComponent(ComponentMetadata parent, TComponent tComp, boolean anonymous)
   {
      ComponentMetadata comp = null;
      
      if (anonymous == false && tComp.getId() == null)
         tComp.setId(".anonymousId#" + (++anonymousId));
      
      if (tComp instanceof TBean)
         comp = new BeanMetadataImpl(context, blueprint, parent, (TBean)tComp);
      
      else if (tComp instanceof TService)
         comp = new ServiceMetadataImpl(context, blueprint, (TService)tComp);
      
      else if (tComp instanceof TReference)
         comp = new ReferenceMetadataImpl(context, blueprint, (TReference)tComp);
      
      if (comp == null)
         throw new IllegalArgumentException("Unsupported component type: " + tComp);
      
      return comp;
   }
}
