/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.blueprint.reflect;

// $Id: ServiceReferenceMetadataImpl.java 90472 2009-06-19 15:11:39Z thomas.diesler@jboss.com $

import org.jboss.osgi.blueprint.BlueprintContext;
import org.jboss.osgi.blueprint.parser.xb.TReference;
import org.osgi.service.blueprint.reflect.ReferenceMetadata;

/**
 * Service reference that will bind to a single matching service in the service
 * registry.
 *
 * Defines the <code>reference</code> element.
 * 
 * @author thomas.diesler@jboss.com
 * @since 30-Jun-2009
 */
public class ReferenceMetadataImpl extends ServiceReferenceMetadataImpl implements ReferenceMetadata
{
   private TReference tReference;
   
   public ReferenceMetadataImpl(BlueprintContext context, BlueprintMetadata blueprint, TReference tReference)
   {
      super(context, blueprint, tReference);
      this.tReference = tReference;
   }

   public long getTimeout()
   {
      return tReference.getTimeout();
   }
   
   public String toString()
   {
      return "Reference[id=" + getId() + "]";
   }

}
