/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.hotdeploy.internal;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.osgi.common.log.LogServiceTracker;
import org.jboss.osgi.hotdeploy.internal.ScannerThread;
import org.jboss.osgi.spi.service.DeployerService;
import org.jboss.osgi.spi.service.DeploymentScannerService;
import org.jboss.osgi.spi.util.BundleDeployment;
import org.jboss.osgi.spi.util.BundleDeploymentFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentScannerImpl
implements DeploymentScannerService {
    private LogServiceTracker log;
    private BundleContext context;
    private long scanInterval;
    private File scanLocation;
    private long scanCount;
    private long lastChange;
    private DeployerService deployer;
    private ScannerThread scannerThread;
    private List<BundleDeployment> lastScan = new ArrayList<BundleDeployment>();
    private Set<DeploymentScannerService.ScanListener> listeners = new LinkedHashSet<DeploymentScannerService.ScanListener>();
    private Map<String, BundleDeployment> deploymentCache = new HashMap<String, BundleDeployment>();
    private boolean traceBundles = false;

    public DeploymentScannerImpl(BundleContext context) {
        this.log = new LogServiceTracker(context);
        this.context = context;
        ServiceReference sref = context.getServiceReference(DeployerService.class.getName());
        this.deployer = (DeployerService)context.getService(sref);
        this.initScanner(context);
    }

    public long getScanCount() {
        return this.scanCount;
    }

    public long getScanInterval() {
        return this.scanInterval;
    }

    public URL getScanLocation() {
        return this.toURL(this.scanLocation.getAbsolutePath());
    }

    public long getLastChange() {
        return this.lastChange;
    }

    public void start() {
        String osgiHome = System.getProperty("osgi.home");
        String scandir = this.scanLocation.getAbsolutePath();
        if (scandir.startsWith(osgiHome)) {
            scandir = "..." + scandir.substring(osgiHome.length());
        }
        this.log.log(3, "Start DeploymentScanner: [scandir=" + scandir + ",interval=" + this.scanInterval + "ms]");
        this.scannerThread = new ScannerThread(this.context, this);
        this.lastChange = System.currentTimeMillis();
        this.scannerThread.start();
    }

    public void stop() {
        if (this.scannerThread != null) {
            this.log.log(3, "Stop DeploymentScanner");
            this.scannerThread.stopScan();
            this.scannerThread = null;
        }
    }

    public void addScanListener(DeploymentScannerService.ScanListener listener) {
        this.listeners.add(listener);
    }

    public void removeScanListener(DeploymentScannerService.ScanListener listener) {
        this.listeners.remove(listener);
    }

    public void scan() {
        int newDiff;
        int oldDiff;
        ArrayList<DeploymentScannerService.ScanListener> scanListeners = new ArrayList<DeploymentScannerService.ScanListener>(this.listeners);
        for (DeploymentScannerService.ScanListener listener : scanListeners) {
            listener.beforeScan((DeploymentScannerService)this);
        }
        List<BundleDeployment> currScan = Arrays.asList(this.getBundleDeployments());
        if (this.traceBundles) {
            this.logBundleDeployments("Current Scan", currScan);
        }
        if ((oldDiff = this.processOldDeployments(currScan)) + (newDiff = this.processNewDeployments(currScan)) > 0) {
            this.lastChange = System.currentTimeMillis();
        }
        this.lastScan = currScan;
        ++this.scanCount;
        for (DeploymentScannerService.ScanListener listener : scanListeners) {
            listener.afterScan((DeploymentScannerService)this);
        }
    }

    private void logBundleDeployments(String message, List<BundleDeployment> bundleDeps) {
        System.out.println(message);
        for (BundleDeployment dep : bundleDeps) {
            System.out.println("   " + dep);
        }
    }

    private int processOldDeployments(List<BundleDeployment> currScan) {
        ArrayList<BundleDeployment> diff = new ArrayList<BundleDeployment>();
        for (BundleDeployment dep : this.lastScan) {
            if (currScan.contains(dep)) continue;
            Bundle bundle = this.getBundle(dep);
            if (bundle == null) {
                this.deploymentCache.remove(dep.getLocation().toExternalForm());
                continue;
            }
            int state = bundle.getState();
            if (state != 2 && state != 4 && state != 32) continue;
            this.deploymentCache.remove(dep.getLocation().toExternalForm());
            diff.add(dep);
        }
        if (this.traceBundles) {
            this.logBundleDeployments("OLD diff", diff);
        }
        try {
            BundleDeployment[] depArr = diff.toArray(new BundleDeployment[diff.size()]);
            this.deployer.undeploy(depArr);
        }
        catch (Exception ex) {
            this.log.log(1, "Cannot undeploy bundles", (Throwable)ex);
        }
        return diff.size();
    }

    private int processNewDeployments(List<BundleDeployment> currScan) {
        ArrayList<BundleDeployment> diff = new ArrayList<BundleDeployment>();
        for (BundleDeployment dep : currScan) {
            if (this.lastScan.contains(dep) || this.getBundle(dep) != null) continue;
            diff.add(dep);
        }
        if (this.traceBundles) {
            this.logBundleDeployments("NEW diff", diff);
        }
        try {
            BundleDeployment[] depArr = diff.toArray(new BundleDeployment[diff.size()]);
            this.deployer.deploy(depArr);
        }
        catch (Exception ex) {
            this.log.log(1, "Cannot deploy bundles", (Throwable)ex);
        }
        return diff.size();
    }

    public BundleDeployment[] getBundleDeployments() {
        ArrayList<BundleDeployment> bundles = new ArrayList<BundleDeployment>();
        File[] listFiles = this.scanLocation.listFiles();
        if (listFiles == null) {
            this.log.log(2, "Cannot list files in: " + this.scanLocation);
        }
        if (listFiles != null) {
            for (File file : listFiles) {
                URL bundleURL = this.toURL(file);
                BundleDeployment dep = this.deploymentCache.get(bundleURL.toExternalForm());
                if (dep == null) {
                    try {
                        dep = BundleDeploymentFactory.createBundleDeployment((URL)bundleURL);
                        dep.setAutoStart(true);
                        this.deploymentCache.put(bundleURL.toExternalForm(), dep);
                    }
                    catch (BundleException ex) {
                        this.log.log(2, "Cannot obtain bundle deployment for: " + file);
                    }
                }
                bundles.add(dep);
            }
        }
        BundleDeployment[] arr = new BundleDeployment[bundles.size()];
        return bundles.toArray(arr);
    }

    private void initScanner(BundleContext context) {
        String scanLoc;
        this.scanInterval = 2000L;
        String interval = context.getProperty("org.jboss.osgi.hotdeploy.interval");
        if (interval != null) {
            this.scanInterval = new Long(interval);
        }
        if ((scanLoc = context.getProperty("org.jboss.osgi.hotdeploy.scandir")) == null) {
            throw new IllegalStateException("Cannot obtain value for property: 'org.jboss.osgi.hotdeploy.scandir'");
        }
        try {
            URL scanURL = new URL(scanLoc);
            this.scanLocation = new File(scanURL.getPath());
        }
        catch (MalformedURLException ex) {
            // empty catch block
        }
        File scanFile = new File(scanLoc);
        if (!scanFile.exists()) {
            throw new IllegalStateException("Scan location does not exist: " + scanLoc);
        }
        if (!scanFile.isDirectory()) {
            throw new IllegalStateException("Scan location is not a directory: " + scanLoc);
        }
        this.scanLocation = scanFile;
    }

    private Bundle getBundle(BundleDeployment dep) {
        String symbolicName = dep.getSymbolicName();
        Version version = Version.parseVersion((String)dep.getVersion());
        Bundle bundle = null;
        for (Bundle aux : this.context.getBundles()) {
            Version auxVersion;
            if (!aux.getSymbolicName().equals(symbolicName) || !version.equals((Object)(auxVersion = aux.getVersion()))) continue;
            bundle = aux;
            break;
        }
        return bundle;
    }

    private URL toURL(File file) {
        try {
            return file.toURL();
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("Invalid URL: " + file);
        }
    }

    private URL toURL(String urlStr) {
        try {
            return new URL(urlStr);
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("Invalid URL: " + urlStr);
        }
    }
}

