/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.hotdeploy.internal;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.osgi.deployment.deployer.DeployerService;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.hotdeploy.DeploymentScannerService;
import org.jboss.osgi.hotdeploy.internal.ScannerThread;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentScannerImpl
implements DeploymentScannerService {
    private static final Logger log = Logger.getLogger(DeploymentScannerImpl.class);
    private BundleContext context;
    private long scanInterval;
    private File scanLocation;
    private long scanCount;
    private long beforeStart;
    private long lastChange;
    private DeployerService deployer;
    private ScannerThread scannerThread;
    private List<Deployment> lastScan = new ArrayList<Deployment>();
    private Map<String, Deployment> deploymentCache = new HashMap<String, Deployment>();

    public DeploymentScannerImpl(BundleContext context) {
        this.context = context;
        ServiceReference sref = context.getServiceReference(DeployerService.class.getName());
        if (sref == null) {
            throw new IllegalStateException("Cannot obtain deployer service");
        }
        this.deployer = (DeployerService)context.getService(sref);
        this.initScanner(context);
    }

    @Override
    public long getScanCount() {
        return this.scanCount;
    }

    @Override
    public long getScanInterval() {
        return this.scanInterval;
    }

    @Override
    public URL getScanLocation() {
        return this.toURL(this.scanLocation.getAbsolutePath());
    }

    @Override
    public long getLastChange() {
        return this.lastChange;
    }

    public void start() {
        String osgiHome = System.getProperty("osgi.home");
        String scandir = this.scanLocation.getAbsolutePath();
        if (scandir.startsWith(osgiHome)) {
            scandir = "..." + scandir.substring(osgiHome.length());
        }
        log.info((Object)("Start DeploymentScanner: [scandir=" + scandir + ",interval=" + this.scanInterval + "ms]"));
        this.scannerThread = new ScannerThread(this.context, this);
        this.lastChange = System.currentTimeMillis();
        this.scannerThread.start();
    }

    public void stop() {
        if (this.scannerThread != null) {
            log.info((Object)"Stop DeploymentScanner");
            this.scannerThread.stopScan();
            this.scannerThread = null;
        }
    }

    @Override
    public void scan() {
        List<Deployment> currScan = Arrays.asList(this.getBundleDeployments());
        this.logBundleDeployments("Current Scan", currScan);
        int oldDiff = this.processOldDeployments(currScan);
        int newDiff = this.processNewDeployments(currScan);
        if (oldDiff + newDiff > 0) {
            this.lastChange = System.currentTimeMillis();
        }
        this.lastScan = currScan;
        ++this.scanCount;
        float diff = (float)(this.lastChange - this.beforeStart) / 1000.0f;
        if (this.scanCount == 1L) {
            log.info((Object)("JBossOSGi Runtime started in " + diff + "sec"));
        }
    }

    private void logBundleDeployments(String message, List<Deployment> bundleDeps) {
        if (log.isTraceEnabled()) {
            log.trace((Object)message);
            for (Deployment dep : bundleDeps) {
                log.trace((Object)("   " + dep));
            }
        }
    }

    private int processOldDeployments(List<Deployment> currScan) {
        ArrayList<Deployment> diff = new ArrayList<Deployment>();
        for (Deployment dep : this.lastScan) {
            if (currScan.contains(dep)) continue;
            Bundle bundle = this.getBundle(dep);
            if (bundle == null) {
                this.deploymentCache.remove(dep.getLocation());
                continue;
            }
            int state = bundle.getState();
            if (state != 2 && state != 4 && state != 32) continue;
            this.deploymentCache.remove(dep.getLocation());
            diff.add(dep);
        }
        this.logBundleDeployments("OLD diff", diff);
        if (diff.size() > 0) {
            try {
                Deployment[] depArr = diff.toArray(new Deployment[diff.size()]);
                this.deployer.undeploy(depArr);
            }
            catch (Exception ex) {
                log.error((Object)"Cannot undeploy bundles", (Throwable)ex);
            }
        }
        return diff.size();
    }

    private int processNewDeployments(List<Deployment> currScan) {
        ArrayList<Deployment> diff = new ArrayList<Deployment>();
        for (Deployment dep : currScan) {
            if (this.lastScan.contains(dep) || this.getBundle(dep) != null) continue;
            diff.add(dep);
        }
        this.logBundleDeployments("NEW diff", diff);
        if (diff.size() > 0) {
            try {
                Deployment[] depArr = diff.toArray(new Deployment[diff.size()]);
                this.deployer.deploy(depArr);
            }
            catch (Exception ex) {
                log.error((Object)"Cannot deploy bundles", (Throwable)ex);
            }
        }
        return diff.size();
    }

    @Override
    public Deployment[] getBundleDeployments() {
        ArrayList<Deployment> bundles = new ArrayList<Deployment>();
        File[] listFiles = this.scanLocation.listFiles();
        if (listFiles == null) {
            log.warn((Object)("Cannot list files in: " + this.scanLocation));
        }
        if (listFiles != null) {
            for (File file : listFiles) {
                URL bundleURL = this.toURL(file);
                Deployment dep = this.deploymentCache.get(bundleURL.toExternalForm());
                if (dep == null) {
                    try {
                        dep = this.deployer.createDeployment(bundleURL);
                        dep.setAutoStart(true);
                    }
                    catch (BundleException ex) {
                        log.error((Object)("Cannot create deployment from: " + bundleURL), (Throwable)ex);
                        continue;
                    }
                    this.deploymentCache.put(bundleURL.toExternalForm(), dep);
                }
                bundles.add(dep);
            }
        }
        Deployment[] arr = new Deployment[bundles.size()];
        return bundles.toArray(arr);
    }

    private void initScanner(BundleContext context) {
        String scanLoc;
        this.scanInterval = 2000L;
        this.beforeStart = System.currentTimeMillis();
        String interval = context.getProperty("org.jboss.osgi.hotdeploy.interval");
        if (interval != null) {
            this.scanInterval = new Long(interval);
        }
        if ((scanLoc = context.getProperty("org.jboss.osgi.hotdeploy.scandir")) == null) {
            throw new IllegalStateException("Cannot obtain value for property: 'org.jboss.osgi.hotdeploy.scandir'");
        }
        try {
            URL scanURL = new URL(scanLoc);
            this.scanLocation = new File(scanURL.getPath());
        }
        catch (MalformedURLException ex) {
            // empty catch block
        }
        File scanFile = new File(scanLoc);
        if (!scanFile.exists()) {
            throw new IllegalStateException("Scan location does not exist: " + scanLoc);
        }
        if (!scanFile.isDirectory()) {
            throw new IllegalStateException("Scan location is not a directory: " + scanLoc);
        }
        this.scanLocation = scanFile;
    }

    private Bundle getBundle(Deployment dep) {
        String symbolicName = dep.getSymbolicName();
        Version version = Version.parseVersion((String)dep.getVersion());
        Bundle bundle = null;
        for (Bundle aux : this.context.getBundles()) {
            Version auxVersion;
            if (!aux.getSymbolicName().equals(symbolicName) || !version.equals((Object)(auxVersion = aux.getVersion()))) continue;
            bundle = aux;
            break;
        }
        return bundle;
    }

    private URL toURL(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("Invalid URL: " + file);
        }
    }

    private URL toURL(String urlStr) {
        try {
            return new URL(urlStr);
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("Invalid URL: " + urlStr);
        }
    }
}

