/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.husky.internal;

// $Id: AbstractPackageListener.java 91202 2009-07-14 11:34:29Z thomas.diesler@jboss.com $

import java.util.Collections;
import java.util.List;

import org.jboss.osgi.husky.Context;
import org.jboss.osgi.husky.Request;
import org.jboss.osgi.husky.Response;
import org.jboss.osgi.husky.runtime.PackageListener;
import org.jboss.osgi.husky.runtime.Runner;

/**
 * An abstract {@link PackageListener} implementation. 
 * 
 * @author Thomas.Diesler@jboss.com
 * @since 16-May-2009
 */
public abstract class AbstractPackageListener implements PackageListener
{
   private List<String> testPackages;
   
   public AbstractPackageListener(List<String> packages)
   {
      if (packages == null)
         throw new IllegalArgumentException("Invalid test package: " + packages);
      
      this.testPackages = packages;
      
   }
   
   public List<String> getPackageNames()
   {
      return Collections.unmodifiableList(testPackages);
   }

   public boolean match(Request req)
   {
      String testClass = req.getClassName();
      for (String testPackage : testPackages)
      {
         if (testClass.startsWith(testPackage))
            return true;
      }
      return false;
   }
   
   public Response runTests(Request request) throws ClassNotFoundException
   {
      String testClass = request.getClassName();
      return getRunner().runTests(getContext(), loadTestClass(testClass));
   }

   public abstract Runner getRunner();

   public abstract  Context getContext();

   public abstract Class<?> loadTestClass(String className) throws ClassNotFoundException;
   
   public String toString()
   {
      return testPackages.toString();
   }
}
