/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.husky.runtime.osgi;

// $Id: JMXConnector.java 91507 2009-07-21 19:30:45Z thomas.diesler@jboss.com $

import java.io.InputStream;
import java.util.Properties;

import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

import org.jboss.osgi.husky.internal.AbstractConnector;
import org.jboss.osgi.husky.internal.HuskyLogService;
import org.jboss.osgi.husky.runtime.Connector;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;

/**
 * The JMX connector is a {@link Connector} that process Husky 
 * requests via an JMX invocation. 
 * 
 * @author Thomas.Diesler@jboss.com
 * @since 17-May-2009
 */
public class JMXConnector extends AbstractConnector implements JMXConnectorMBean
{
   /*
    * The ObjectName for this service: jboss.osgi.husky:service=jmx-connector
    */
   public static ObjectName OBJECT_NAME;

   private LogService log;
   private BundleContext context;

   static
   {
      try
      {
         OBJECT_NAME = ObjectName.getInstance("jboss.osgi.husky:service=jmx-connector");
      }
      catch (MalformedObjectNameException ex)
      {
         // ignore
      }
   }

   public JMXConnector(BundleContext context)
   {
      this.log = new HuskyLogService(context);
      this.context = context;
   }

   public void start() throws Exception
   {
      ServiceReference sref = context.getServiceReference(MBeanServer.class.getName());
      if (sref == null)
         throw new IllegalStateException("Cannot obtain MBeanServer service");

      Properties props = new Properties();
      props.setProperty("transport", "jmx");
      context.registerService(Connector.class.getName(), this, props);

      MBeanServer server = (MBeanServer)context.getService(sref);
      server.registerMBean(this, OBJECT_NAME);
      log.log(LogService.LOG_INFO, "JMXConnector registered: " + OBJECT_NAME);
   }

   public void stop() throws Exception
   {
      ServiceReference sref = context.getServiceReference(MBeanServer.class.getName());
      if (sref != null)
      {
         MBeanServer server = (MBeanServer)context.getService(sref);
         if (server.isRegistered(OBJECT_NAME))
            server.unregisterMBean(OBJECT_NAME);
      }
   }

   @Override
   public InputStream process(InputStream reqStream)
   {
      return super.process(reqStream);
   }
}