/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.testing;

//$Id: OSGiPackageAdmin.java 95403 2009-10-22 13:39:47Z thomas.diesler@jboss.com $

import org.osgi.service.packageadmin.PackageAdmin;

/**
 * An abstraction of the OSGi {@link PackageAdmin} service.
 * 
 * @author Thomas.Diesler@jboss.org
 * @since 25-Sep-2008
 */
public interface OSGiPackageAdmin
{
   /**
    * Forces the update (replacement) or removal of packages exported by the specified bundles.
    * 
    * @see {@link PackageAdmin#refreshPackages(org.osgi.framework.Bundle[])}
    * 
    * @param bundles The bundles whose exported packages are to be updated or removed, 
    * or null for all bundles updated or uninstalled since the last call to this method. 
    */
   void refreshPackages(OSGiBundle[] bundles);
}
