/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.husky.runtime;

//$Id: Runner.java 95826 2009-10-30 13:44:32Z thomas.diesler@jboss.com $

import org.jboss.osgi.husky.Context;
import org.jboss.osgi.husky.Response;
import org.jboss.osgi.husky.RuntimeContext;
import org.jboss.osgi.husky.runtime.junit.JUnitRunner;

/**
 * An abstraction of a test runner that executes the given 
 * test case in the isolated test environment.
 * 
 * @author Thomas.Diesler@jboss.com
 * @since 16-May-2009
 */
public interface Runner
{
   /**
    * Run the tests in the given test class.
    * 
    * Simmilar to the {@link JUnitRunner} a valid implementation
    * would do something simmilar to
    * 
    * <ol>
    * <li>Instanciate the test case</li>
    * <li>Inject the context in the field marked by {@link RuntimeContext}</li>
    * <li>Run the individual test methods</li>
    * <li>Collect the test results and wrap them in the {@link Response}</li>
    * </ol>
    * 
    * Note, some test frameworks may choose to use an instance per test method.
    */
   Response runTests(Context context, Class<?> testClass);
   
   /**
    * Inject the {@link Context} in the test case instance
    */
   void injectContext(Class<?> testClass, Object test, Context context) throws Exception;
}
