/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.jaxb;

//$Id: JAXBCapability.java 97050 2009-11-26 22:32:23Z thomas.diesler@jboss.com $

import org.jboss.osgi.spi.capability.Capability;
import org.jboss.osgi.xml.XMLParserCapability;

/**
 * Adds the JAXB capability. 
 * 
 * It is ignored if the {@link JAXBService} is already registered.
 * 
 * Dependent capabilities: {@link XMLParserCapability}.
 * 
 * Installed bundles: jboss-osgi-jaxb.jar
 * 
 * @author thomas.diesler@jboss.com
 * @since 05-May-2009
 */
public class JAXBCapability extends Capability
{
   public JAXBCapability()
   {
      super(JAXBService.class.getName());
      
      addDependency(new XMLParserCapability());
      
      addBundle("bundles/jboss-osgi-jaxb.jar");
   }
}