/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.osgi.service.webconsole.internal.plugins;

//$Id: JBossRenderBridge.java 86385 2009-03-26 15:30:24Z thomas.diesler@jboss.com $

import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.felix.webconsole.AbstractWebConsolePlugin;
import org.apache.felix.webconsole.Render;
import org.apache.felix.webconsole.internal.servlet.OsgiManager;

/** 
 * A copy of the org.apache.felix.webconsole.internal.servlet.RenderBridge 
 * which does not have a public ctor.
 * 
 * We replace the header and footer.
 * 
 * @author Thomas.Diesler@jboss.com
 * @since 26-Mar-2009
 */
@SuppressWarnings("serial")
public class JBossRenderBridge extends AbstractWebConsolePlugin
{
   private final Render render;

   public JBossRenderBridge(Render render)
   {
      this.render = render;
   }

   @Override
   protected String getHeader()
   {
      return PluginHelper.getHeader();
   }

   @Override
   protected void endResponse(HttpServletRequest request, PrintWriter pw)
   {
      String appRoot = (String)request.getAttribute(OsgiManager.ATTR_APP_ROOT);
      String footer = MessageFormat.format(PluginHelper.getFooter(), new Object[]{ appRoot });
      pw.println(footer);
   }
   
   public Render getRender()
   {
      return render;
   }

   public String getTitle()
   {
      return render.getLabel();
   }

   public String getLabel()
   {
      return render.getName();
   }

   protected void renderContent(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException
   {
      render.render(request, response);
   }
}
