/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.compendium;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.webconsole.internal.BaseWebConsolePlugin;
import org.apache.felix.webconsole.internal.Util;
import org.apache.felix.webconsole.internal.servlet.OsgiManager;
import org.json.JSONException;
import org.json.JSONWriter;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogReaderService;

public class LogServlet
extends BaseWebConsolePlugin {
    public static final String LABEL = "logs";
    public static final String TITLE = "Log Service";
    private static final int MAX_LOGS = 200;
    static /* synthetic */ Class class$org$osgi$service$log$LogReaderService;

    public String getLabel() {
        return LABEL;
    }

    public String getTitle() {
        return TITLE;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String minLevel = LogServlet.getParameter(req, "minLevel");
        resp.setContentType("application/json");
        resp.setCharacterEncoding("utf-8");
        this.renderJSON(resp.getWriter(), this.extractLogLevel(minLevel));
    }

    private void renderJSON(PrintWriter pw, int minLogLevel) throws IOException {
        LogReaderService logReaderService = (LogReaderService)this.getService((class$org$osgi$service$log$LogReaderService == null ? (class$org$osgi$service$log$LogReaderService = LogServlet.class$("org.osgi.service.log.LogReaderService")) : class$org$osgi$service$log$LogReaderService).getName());
        StringBuffer statusLine = new StringBuffer();
        if (logReaderService == null) {
            statusLine.append("Log Service is not installed/running.");
        } else {
            statusLine.append("Log Service is running.");
        }
        JSONWriter jw = new JSONWriter((Writer)pw);
        try {
            jw.object();
            jw.key("status");
            jw.value((Object)statusLine);
            jw.key("data");
            jw.array();
            int index = 0;
            Enumeration logEntries = logReaderService.getLog();
            while (logEntries.hasMoreElements() && index < 200) {
                LogEntry nextLog = (LogEntry)logEntries.nextElement();
                if (nextLog.getLevel() > minLogLevel) continue;
                this.logJson(jw, nextLog, index++);
            }
            jw.endArray();
            jw.endObject();
        }
        catch (JSONException je) {
            throw new IOException(je.toString());
        }
    }

    private int extractLogLevel(String minLevel) {
        if (minLevel == null) {
            return 4;
        }
        int minLogLevel = 4;
        try {
            minLogLevel = Integer.parseInt(minLevel);
        }
        catch (Throwable t) {
            minLogLevel = 4;
        }
        return minLogLevel;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String minLevel = LogServlet.getParameter(request, "minLevel");
        String info = request.getPathInfo();
        if (info.endsWith(".json")) {
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
            PrintWriter pw = response.getWriter();
            this.renderJSON(pw, this.extractLogLevel(minLevel));
            return;
        }
        super.doGet(request, response);
    }

    protected void renderContent(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        String appRoot = (String)request.getAttribute(OsgiManager.ATTR_APP_ROOT);
        Util.script(pw, appRoot, "logs.js");
        pw.println("<div id='plugin_content'/>");
        Util.startScript(pw);
        pw.println("renderLogs( );");
        Util.endScript(pw);
    }

    private void logJson(JSONWriter jw, LogEntry info, int index) throws JSONException {
        jw.object();
        jw.key("id");
        jw.value((Object)String.valueOf(index));
        jw.key("received");
        jw.value(info.getTime());
        jw.key("level");
        jw.value((Object)this.logLevel(info.getLevel()));
        jw.key("message");
        jw.value((Object)info.getMessage());
        jw.key("service");
        jw.value((Object)this.serviceDescription(info.getServiceReference()));
        jw.key("exception");
        jw.value((Object)this.exceptionMessage(info.getException()));
        jw.endObject();
    }

    private String serviceDescription(ServiceReference serviceReference) {
        if (serviceReference == null) {
            return "";
        }
        return serviceReference.toString();
    }

    private String logLevel(int level) {
        switch (level) {
            case 3: {
                return "INFO";
            }
            case 2: {
                return "WARNING";
            }
            case 1: {
                return "ERROR";
            }
        }
        return "DEBUG";
    }

    private String exceptionMessage(Throwable e) {
        if (e == null) {
            return "";
        }
        return e.getClass().getName() + ": " + e.getMessage();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

